### Name: bugs
### Title: Run WinBUGS from R
### Aliases: bugs
### Keywords: interface models

### ** Examples

# An example model file is given in:
model.file <- file.path(.path.package("R2WinBUGS"), "model", "schools.txt")
# Let's take a look:
file.show(model.file)

# Some example data (see ?schools for details):
data(schools)
schools

J <- nrow(schools)
y <- schools$estimate
sigma.y <- schools$sd
data <- list ("J", "y", "sigma.y")
inits <- function(){
    list(theta = rnorm(J, 0, 100), mu.theta = rnorm(1, 0, 100),
        sigma.theta = runif(1, 0, 100))
}
parameters <- c("theta", "mu.theta", "sigma.theta")

## Not run: 
##D ## You may need to edit "bugs.directory",
##D ## also you need write access in the working directory:
##D schools.sim <- bugs(data, inits, parameters, model.file,
##D     n.chains = 3, n.iter = 1000,
##D     bugs.directory = "c:/Program Files/WinBUGS14/",
##D     working.directory = NULL)
##D print(schools.sim)
##D plot(schools.sim)
## End(Not run)



