### Name: awstindex
### Title: Tail index estimation
### Aliases: awstindex
### Keywords: smooth nonparametric models

### ** Examples

###
###   Estimate the tail-index of a cauchy distribution
###   absolute values can be used because of the symmetry of centered cauchy
###
set.seed(1)
n <- 500
x <- rcauchy(n)
tmp <- awstindex(abs(x),hmax=n)
tmp$tindex
###
###   now show the segmentation generated by AWS 
###
plot(tmp$intensity[1:250],type="l")



