### Name: awstri
### Title: Three-dimensional Adaptive Weights Smoothing
### Aliases: awstri
### Keywords: regression nonparametric smooth

### ** Examples

xy <- rbind(rep(0:30,31),rep(0:30,rep(31,31)))
w3 <- array(0,c(31,31,31))
w3[4:28,4:28,4:28] <- 1
dim(w3) <- c(961,31)
w3[((xy[1,]-15)^2+(xy[2,]-15)^2)<=144,16] <- 0
for(i in 1:12) {
   r2 <- 144-i*i
   w3[((xy[1,]-15)^2+(xy[2,]-15)^2)<=r2,16+c(-i,i)] <- 0
}
dim(w3) <- c(31,31,31)
w3[10:22,10:22,10:22] <- 1
dim(w3) <- c(961,31)
w3[((xy[1,]-15)^2+(xy[2,]-15)^2)<=36,16] <- 0
for(i in 1:6) {
   r2 <- 36-i*i
   w3[((xy[1,]-15)^2+(xy[2,]-15)^2)<=r2,16+c(-i,i)] <- 0
}
dim(w3) <- c(31,31,31)
sigma <- .4
y <- w3+rnorm(w3,0,sigma)
#  increase rmax for better results
yhat <- awstri(y,rmax=2)
rm(y,yhat,w3,xy)



