### Name: awsuni
### Title: One-dimensional Adaptive Weights Smoothing
### Aliases: awsuni
### Keywords: regression nonparametric smooth

### ** Examples

#  Blocks data (from Donoho, Johnstone, Kerkyacharian and Picard (1995))
mofx6 <- function(x){
xj <- c(10,13,15,23,25,40,44,65,76,78,81)/100
hj <- c(40,-50,30,-40,50,-42,21,43,-31,21,-42)*.37
Kern <- function(x) (1-sign(x))/2
apply(Kern(outer(xj,x,"-"))*hj,2,sum)
}
x <- seq(0,1,1/2047)
fx6 <- mofx6(x)
#    sigma==3
y <- rnorm(fx6,fx6,3)
tmp <- awsuni(y)
par(mfrow=c(1,1))
plot(x,y)
lines(x,tmp$yhat,col=2)
lines(x,fx6,col=3)
title(expression(paste("AWS Reconstruction of blocks data  ",sigma==3)))
rm(x,y,fx6,mofx6,tmp)



