\name{dinfo}
\alias{ibeta}
\alias{igamma}

\title{Information for Beta and Gamma Distributions}
\description{
  Show means, variances and modes for beta and gamma distributions.
}

\usage{
ibeta(mean, var, shape1, shape2)
igamma(mean, var, shape, scale)
}

\arguments{
  \item{mean, var}{Numeric vectors giving means and variances.}
  \item{shape1, shape2}{Numeric vectors. See \code{\link{dbeta}}.}
  \item{shape, scale}{Numeric vectors. See \code{\link{dgamma}}.}  
}
\details{
  For \code{ibeta}, either both of \code{mean} and \code{var} or both of
  \code{shape1} and \code{shape2} must be specified.
  For \code{igamma}, either both of \code{mean} and \code{var} or both of
  \code{shape} and \code{scale} must be specified.
  The pair of vectors that are passed to each function define a set
  of beta/gamma distributions.
  If one vector is shorter than the other, the shorter vector is
  replicated.
}

\value{
  A matrix with five columns and \eqn{n} rows, where \eqn{n} is the
  length of the longest argument.
  If \eqn{n = 1} the dimension is dropped (i.e. a vector of length
  five is returned).
  The columns contain the means, variances, modes, and the
  shape/scale parameters of the specified distributions.
  If a mode is \code{NA}, it does not exist, or it is not unique, or
  it does not occur in the interior of the support.
  If an entire row is \code{NA}, the corresponding arguments do not
  lead to a valid distribution.
}

\examples{
ibeta(shape1 = 5, shape2 = 4)
ibeta(mean = seq(0.1,0.9,0.2), var = 0.03)
igamma(shape=c(38.9,7.1,47), scale=c(1.5,6.3,2.6))
}

\seealso{\code{\link{dbeta}}, \code{\link{dgamma}}}

\keyword{distribution}


\eof
\name{evdbayes-internal}

\alias{dprior.quant}
\alias{dprior.prob}
\alias{dprior.norm}
\alias{gevlik2}
\alias{pplik2}
\alias{oslik2}
\alias{dpost}
\alias{gibbs}

\title{Internal Functions}

\description{
  Not to be called by the user.
}

\keyword{internal}

\eof
\name{lh}
\alias{gevlik}
\alias{pplik}
\alias{oslik}

\title{Calculate Log-likelihoods}
\description{
  Calculate log-likelihoods for the gev, order statistics or
  point process models.
}
\usage{
pplik(par, data, thresh, noy, trend, exact = FALSE)
gevlik(par, data, trend)
oslik(par, data, trend) 
}
\arguments{
  \item{par}{If \code{trend} is missing, should be a numeric vector of
    length three, containing the location, scale and shape parameters.
    If \code{trend} is not missing, should be a numeric vector of length
    four, containing the location intercept, scale, shape and location
    trend parameters, in that order.}
  \item{data}{For \code{pplik} and \code{gevlik}; a non-empty numeric
    vector containing the data at which the likelihood is evaluated,
    possibly containing missing values. For \code{oslik}; a numeric
    matrix (see the user's guide).}
  \item{thresh}{Threshold. Typically a single number or a vector of
    the same length as \code{data}.}
  \item{noy}{Number of years/periods of observations, excluding
    any missing values.}
  \item{trend}{Trend vector (optional). If given, should be the same
    length as \code{data} for \code{pplik} and \code{gevlik}.
    For \code{oslik}, should contain one value for each row
    of \code{data}.}
  \item{exact}{In general, the point process likelihood includes an
    approximation to an integral. If \code{exact} is \code{TRUE}, every
    value in \code{trend} and \code{thresh} is used for the
    approximation.}
}
\details{
  See the user's guide. 
}
\note{
  These functions are essentially internal, and need not be called
  by the user. They are documented only because their arguments
  (excluding \code{par}) can be passed to
  \code{\link{posterior}}.
}

\seealso{\code{\link{posterior}}, \code{\link{prior.prob}}}

\keyword{models}


\eof
\name{mc.quant}
\alias{mc.quant}

\title{Compute GEV Quantiles from Markov Chains}
\description{
  Compute gev quantiles from samples stored within a Markov chain,
  corresponding to specified probabilities in the upper tail.
}

\usage{
mc.quant(post, p)
}

\arguments{
  \item{post}{A Markov chain generated using \code{posterior},
    containing samples of gev parameters.}
  \item{p}{A numeric vector of upper tail probabilities.}  
}

\value{
  A matrix with \eqn{n} rows and \eqn{m} columns, where \eqn{n} is the
  number of samples stored within the chain, and \eqn{m} is the
  length of the vector \eqn{p}.
  If \eqn{m = 1} the dimension is dropped (i.e. a vector of length
  \eqn{n} is returned).
  The \code{(i,j)}th entry contains the gev quantile coresponding to the
  upper tail probability \code{p[j]}, evaluated at the parameters
  within sample \code{i}.
  
  If a linear trend on the location has been implemented, the quantiles
  correspond to the distribution obtained when the trend parameter is
  zero.
}
\details{
  See the user's guide. 
}

\seealso{\code{\link{posterior}}}

\keyword{manip}


\eof
\name{mposterior}
\alias{mposterior}

\title{Maximizing Posterior Distributions}
\description{
  Maximizing prior and posterior distibutions for the
  location (with optional trend), scale and shape parameters under
  the gev, order statistics or point process models.
}
    
\usage{
mposterior(init, prior, lh = c("none", "gev", "pp", "os"),
    method = c("Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN"),
    lower = -Inf, upper = Inf, control = list(), hessian = FALSE, ...)
}

\arguments{
  \item{init}{Numeric vector of length three/four, giving the initial
    values for the optimization.}
  \item{prior}{An object of class \code{"evprior"}, constructed
    using \code{prior.prob}, \code{prior.quant} or
    \code{prior.norm}.}
  \item{lh}{A character string specifying the likelihood; either
    \code{"gev"} for gev, \code{"os"} for order statistics,
    \code{"pp"} for Poisson process or \code{"none"} for none
    (the default). The latter can be used to maximize the
    prior distribution.}
  \item{method}{The method to be used. See \code{\link{optim}}.}
  \item{lower, upper}{Bounds on the variables for the \code{"L-BFGS-B"}
    method. See \code{\link{optim}}.}
  \item{control}{A list of control parameters. See \code{\link{optim}}.}
  \item{hessian}{Logical. See \code{\link{optim}}.}
  \item{...}{Arguments to the likelihood. Should include \code{data}
    unless \code{lh} is \code{"none"}. Should also include \code{thresh}
    and \code{noy} if \code{lh} is \code{"pp"}.
    Should include the vector \code{trend} if a linear trend on
    the location is implemented.
    See \code{\link{pplik}} for details.}
}


\value{
  A list. See \code{\link{optim}}.
}

\seealso{\code{\link{pplik}}, \code{\link{posterior}}, \code{\link{prior.prob}}}

\keyword{optimize}


\eof
\name{posterior}
\alias{posterior}

\title{MCMC Sampling of Posterior Distributions}
\description{
  Constructing MCMC samples of prior and posterior distibutions for
  the location (with optional trend), scale and shape parameters under
  the gev, order statistics or point process models.
}
\usage{
posterior(n, init, prior, lh = c("none", "gev", "pp","os"), \dots, psd,
    burn = 0, thin = 1)
}

\arguments{
  \item{n}{The run-length; the number of sampled vectors
    (excluding \code{init}).}
  \item{init}{Numeric vector of length three/four, giving the initial
    values for the chain, taken to be iteration zero.}
  \item{prior}{An object of class \code{"evprior"}, constructed
    using \code{prior.prob}, \code{prior.quant} or
    \code{prior.norm}.}
  \item{lh}{A character string specifying the likelihood; either
    \code{"gev"} for gev, \code{"os"} for order statistics,
    \code{"pp"} for Poisson process or \code{"none"} for none
    (the default). The latter can be used to sample from the
    prior distribution.}
  \item{\dots}{Arguments to the likelihood. Should include \code{data}
    unless \code{lh} is \code{"none"}. Should also include \code{thresh}
    and \code{noy} if \code{lh} is \code{"pp"}.
    Should include the vector \code{trend} if a linear trend on
    the location is implemented.
    See \code{\link{pplik}} for details.}
  \item{psd}{A vector of length three/four containing standard
    deviations for proposal distributions.}
  \item{burn}{The burn-in period (an integer); the first \code{burn}
    iterations (including \code{init}) are excluded from the chain.}
  \item{thin}{The thinning interval (an integer); iteration \eqn{k}
    is stored only if \eqn{k} mod \code{thin} is zero (and if \eqn{k}
    greater than or equal to \code{burn}).}
}
\details{
  See the user's guide. 
}

\value{
  A matrix with \code{1+floor(n/thin)-burn} rows.
  Row labels give the iteration numbers.
  Column labels give parameter names.
  
  An attribute \code{ar} is also returned.
  This is a matrix containing acceptence rates in the first row
  (the number of proposals accepted divided by the number of
  iterations) and ``external rates'' in the second (the number of
  proposals that resulted in a zero likelihood, divided by the
  number of iterations).
}

\seealso{\code{\link{pplik}}, \code{\link{prior.prob}}}

\examples{
mat <- diag(c(10000, 10000, 100))
pn <- prior.norm(mean = c(0,0,0), cov = mat)
\dontrun{data(portpirie)}
\dontrun{posterior(1000, init = c(5,1,0.1), prior = pn, lh = "gev",
    data = portpirie, psd = c(.02,.1,.1))}
}
\keyword{models}


\eof
\name{prior}
\alias{prior.prob}
\alias{prior.quant}
\alias{prior.norm}

\title{Construction of Prior Distributions}
\description{
  Constructing prior distibutions for the location, scale and shape
  parameters using normal, beta or gamma distributions.
  A linear trend for the location can also be specified, using a
  prior normal distribution centered at zero for the trend
  parameter.
  
}
\usage{
prior.prob(quant, alpha, trendsd = 0)
prior.quant(prob = 10^-(1:3), shape, scale, trendsd = 0)
prior.norm(mean, cov, trendsd = 0)
}

\arguments{
  \item{quant, alpha}{Numeric vectors of length three and four
    respectively.
    Beta prior distibutions are placed on probability ratios
    corresponding to the quantiles given in \code{quant}.}
  \item{prob, shape, scale}{Numeric vectors of length three.
    Gamma prior distibutions, with parameters \code{shape} and
    \code{scale}, are placed on quantile differences corresponding
    to the probabilities given in \code{prob}.}
  \item{mean, cov}{The prior distibution for the location, log(scale)
    and shape is taken to be trivariate normal, with mean \code{mean}
    (a numeric vector of length three) and covariance matrix \code{cov}
    (a symmetric positive definite three by three matrix).}
  \item{trendsd}{The standard deviation for the marginal normal prior
    distribution (with mean zero) placed on the linear trend parameter
    for the location. If this is zero (the default) a linear trend is
    not implemented.}
}
\details{
  See the user's guide. 
}

\value{
  Returns an object of class \code{"evprior"}, which is essentially
  just a list of the arguments passed.
}

\seealso{\code{\link{posterior}}, \code{\link{pplik}}}

\examples{
mat <- diag(c(10000, 10000, 100))
prior.norm(mean = c(0,0,0), cov = mat, trendsd = 10)
prior.quant(shape = c(38.9,7.1,47), scale = c(1.5,6.3,2.6))
prior.prob(quant = c(85,88,95), alpha = c(4,2.5,2.25,0.25))
}
\keyword{models}


\eof
\name{rainfall}
\alias{rainfall}
\title{Daily Aggregate Rainfall}
\usage{data(rainfall)}
\description{
  A numeric vector of length 20820 containing daily aggregate
  rainfall observations, in millimetres, recorded at a rain gauge
  in England over a 57 year period, beginning on a leap year.
  Three of these years contain only missing values.
}
\format{A vector containing 20820 observations.}
\source{
  Unknown.
}  
\keyword{datasets}

\eof
\name{rl.pred}
\alias{rl.pred}

\title{Return Level Plots for GEV Predictive Distributions}
\description{
  Produce return level plots depicting prior and posterior predictive
  gev distributions.
}

\usage{
rl.pred(post, qlim, period = 1, lty = 1, col = 1, xlab =
    "-1/log(1-1/return period)", ylab = "return level", \dots)
}

\arguments{
  \item{post}{A Markov chain generated using \code{posterior},
    containing samples from the corresponding prior/posterior
    distribution.}
  \item{qlim}{A vector of length two, giving the limits for
    the quantiles at which the predictive probabilities are
    calculated.}
  \item{period}{A vector of integers. One curve is plotted for
    each element of \code{period}. The \eqn{i}th curve depicts
    the probabilities that that quantiles will be exceeded over
    the next \code{period[i]} periods.}
  \item{lty}{Passed to \code{matplot}.}
  \item{col}{Passed to \code{matplot}.}
  \item{xlab, ylab}{Labels for the x and y axes.}
  \item{\dots}{Other arguments passed to \code{matplot}.}
}

\value{
  The first two arguments to \code{matplot} are returned invisibly
  as a list.  
  
  If a linear trend on the location has been implemented, the plot
  corresponds to the distribution obtained when the trend parameter is
  zero.
}
\details{
  See the user's guide. 
}

\seealso{\code{\link{matplot}}, \code{\link{posterior}}}

\keyword{hplot}


\eof
\name{rl.pst}
\alias{rl.pst}

\title{Return Level Plots Depicting Distributions of GEV Quantiles}
\description{
  Produce return level plots depicting prior and posterior
  distributions of gev quantiles.
}

\usage{
rl.pst(post, ci = 0.9, lty = c(2,1), col = c(2,1), xlab =
    "-1/log(1-1/return period)", ylab = "return level",  \dots)
}

\arguments{
  \item{post}{A Markov chain generated using \code{posterior},
    containing samples from the corresponding prior/posterior
    distribution.}
  \item{ci}{The confidence coefficient for the plotted
    prior/posterior probability interval.}
  \item{lty}{Passed to \code{matplot}. The first and
    second values specify the line type of the probability
    interval and the median line respectively.}
  \item{col}{Passed to \code{matplot}. The first and
    second values specify the colour of the probability
    interval and the median line respectively.}
  \item{xlab, ylab}{Labels for the x and y axes.}
  \item{\dots}{Other arguments passed to \code{matplot}.}
}

\value{
  The first two arguments to \code{matplot} are returned invisibly
  as a list. 
  
  If a linear trend on the location has been implemented, the plot
  corresponds to the distribution obtained when the trend parameter is
  zero.
}
\details{
  See the user's guide. 
}

\seealso{\code{\link{matplot}}, \code{\link{posterior}}}

\keyword{hplot}


\eof
