\name{apple}
\alias{apple}
\non_function{}
\title{Worm Infestations in Apple Crops}
\description{
The \code{apple} data frame provides the number of apples (in 100s) on
18 different apple trees.  For 12 trees, the percentage of apples with
worms (x 100) is also given.
}
\format{
    This data frame contains the following columns:
    \describe{
    \item{size}{hundreds of apples on the tree.}
    \item{worms}{percentage (x100) of apples harboring worms.}
  }
}
\details{
    These data constitute Table 6.1 in Little and Rubin (1987), adapted from Table 6.9.1 of
    Snedecor and Cochran (1967).
}
\source{
 Little, R. J. A., and Rubin, D. B. (1987) \emph{Statistical Analysis
     with Missing Data}.  New York: Wiley.
 
 Snedecor, G. W., and Cochran, W. G.  (1967)  \emph{Statistical
     Methods}, 6th ed.  Ames: Iowa State University Press.
}
\examples{
library(mvnmle)
data(apple)

mlest(apple)
}
\keyword{datasets}







\eof
\name{getclf}
\alias{getclf}
\title{Create likelihood function for multivariate data with missing values.}
\description{
  \code{getclf} returns a function proportional to twice the negative
  log likelihood function for multivariate normal data with missing
  values.  This is a private function used in \code{mlest}.
}
\usage{
getclf(data, freq)
}
\arguments{
  \item{data}{A data frame sorted so that records with identical
      patterns of missingness are grouped together.}
  \item{freq}{An integer vector specifying the number of records in each
  block of data with identical patterns of missingness.}
}
\details{
  The argument of the returned function is the vector of parameters.
  The parameterization is: mean vector first, followed
      by the log of the diagonal elements of the inverse of the Cholesky
      factor, and then the elements of the inverse of the Cholesky
      factor above the main diagonal.  These off-diagonal elements are
      ordered by column (left to right), and then by row within column
      (top to bottom).
}
\value{
  A function proportional to twice the negative log likelihood of the
  parameters given the data.
}
\references{ Little, R. J. A., and Rubin, D. B. (1987) \emph{Statistical Analysis
     with Missing Data}.  New York: Wiley. }

\seealso{ \code{\link{mlest}} }

\keyword{multivariate}






\eof
\name{getstartvals}
\alias{getstartvals}
\title{Obtain starting values for maximum likelihood estimation.}
\description{
  Calculates the starting values to be passed to \code{nlm} for
  minimization of the negative log-likelihood for multivariate normal
  data with missing values.  This function is private to \code{mlest}.
}
\usage{
getstartvals(x, eps=0.001)
}

\arguments{
  \item{x}{Multivariate data, potentially with missing values. }
  \item{eps}{All eigenvalues of the variance-covariance matrix less than
  \code{eps} times the smallest positive eigenvalue are set to
  \code{eps} times the smallest positive eigenvalue.}
}
\details{
  Starting values for the mean vector are simply sample means.  Starting
  values for the variance-covariance matrix are derived from the sample
  variance-covariance matrix, after setting eigenvalues less than
  \code{eps} times the smallest positive eigenvalue equal to \code{eps}
  times the smallest positive eigenvalue to enforce positive definiteness. 
}
\value{
  A numeric vector, containing the mean vector first, followed
      by the log of the diagonal elements of the inverse of the Cholesky
      factor of the adjusted sample variance-covariance matrix, and then
      the elements of the inverse of the Cholesky factor above the main diagonal.  These off-diagonal elements are
      ordered by column (left to right), and then by row within column
      (top to bottom).}
}

\seealso{  \code{\link{mlest}} }

\keyword{multivariate}








\eof
\name{make.del}
\alias{make.del}
\title{ Make the upper triangular matrix del from a parameter vector }
\description{
  \code{make.del} takes a parameter vector of length \eqn{k*(k+1)/2} and
  returns the upper triangular \eqn{k \times k} matrix \eqn{\Delta}.
  \code{make.del} is a private function intended for use inside \code{mlest}.
}
\usage{
make.del(pars)
}
\arguments{
  \item{pars}{ A length \eqn{k*(k+1)/2} numerical vector giving the
      elements of \eqn{\Delta}. }
}
\details{
  The first \eqn{k} elements of \code{pars} are the log of the diagonal
  elements of \eqn{\Delta}. The next \eqn{k*(k-1)/2} elements are the
  elements above the main diagonal of \eqn{\Delta}, ordered  by column
  (left to right), and then by row within column (top to bottom).  That
  is to say, if \eqn{\Delta_{ij}} is the element in the \eqn{i}th row
  and \eqn{j}th column of \eqn{\Delta}, then the order of the parameters
  is \eqn{\Delta_{11}, \Delta_{22}, \ldots, \Delta_{kk}, \Delta_{12},
      \Delta_{13}, \Delta_{23}, \Delta_{14}, \ldots,\Delta_{(k-1)k}}.  }

\value{
  An upper triangular \eqn{k \times k} matrix.
}
\references{
    Pinheiro, J. C., and Bates, D. M.  (2000) \emph{Mixed-effects models in
     S and S-PLUS}.  New York: Springer.}

\seealso{ \code{\link{mlest}} }

\keyword{algebra}

\eof
\name{missvals}
\alias{missvals}
\non_function{}
\title{A multivariate data set with missing values.}
\description{
The \code{missvals} data frame has 13 rows and 5 columns.
These are data from Draper and Smith (1968), and are included to
demonstrate ML estimation of mean and variance-covariance parameters of
multivaraite normal data when some observations are missing.
}
\format{
This data frame contains the following columns:
\describe{
\item{x1--x5}{
numeric vectors
}
}
}
\details{
 These data constitute Table 6.4 in Little and Rubin (1987).  They are analyzed both in Rubin (1976) and Little and Rubin (1987).
}
\source{
 Draper, N. R., and Smith, H.  (1968).  \emph{Applied Regression
     Analysis}.  New York: Wiley.
 
 Little, R. J. A., and Rubin, D. B. (1987) \emph{Statistical Analysis
     with Missing Data}.  New York: Wiley.
 
 Rubin, D. B.  (1976)  Comparing regressions when some predictor
     variables are missing.  \emph{Psychometrika} \bold{43}, 3--10.
}
\examples{

library(mvnmle)
data(missvals)

mlest(missvals, iterlim=400)
}
\keyword{datasets}

\eof
\name{mlest}
\alias{mlest}
\title{ML Estimation of Multivariate Normal Data}
\description{
  Finds the maximum likelihood estimates of the mean vector and
  variance-covariance matrix for multivariate normal data with
  (potentially) missing values.
}
\usage{
mlest(data, ...)
}
\arguments{
  \item{data}{A data frame or matrix containing multivariate normal
      data.  Each row should correspond to an observation, and each
      column to a component of the multivariate vector.  Missing values
      should be coded by 'NA'.}
  \item{\dots}{Optional arguments to be passed to the nlm optimization routine.}
}
\details{
  The estimate of the variance-covariance matrix returned by
  \code{mlest} is necessarily positive semi-definite.  Internally,
  \code{nlm} is used to minimize the negative log-likelihood, so
  optional arguments mayh be passed to \code{nlm} which modify the
  details of the minimization algorithm, such as \code{iterlim}.  The
  likelihood is specified in terms of the inverse of the Cholesky factor
  of the variance-covariance matrix (see Pinheiro and Bates 2000).

  \code{mlest} cannot handle data matrices with more than 50 variables.
  Each varaible must also be observed at least once.
}
\value{

  \item{muhat}{MLE of the mean vector.}
  \item{sigmahat}{MLE of the variance-covariance matrix.}
  \item{value}{The objective function that is minimized by \code{nlm}.
      Is is proportional to twice the negative log-likelihood.}
  \item{gradient}{The curvature of the likelihood surface at the MLE, in
      the parameterization used internally by the optimization
      algorithm.  This parameterization is: mean vector first, followed
      by the log of the diagonal elements of the inverse of the Cholesky
      factor, and then the elements of the inverse of the Cholesky
      factor above the main diagonal.  These off-diagonal elements are
      ordered by column (left to right), and then by row within column
      (top to bottom).}
  \item{stop.code}{The stop code returned by \code{nlm}.}
  \item{iterations}{The number of iterations used by \code{nlm}.}
     
}
\references{
 Little, R. J. A., and Rubin, D. B. (1987) \emph{Statistical Analysis
     with Missing Data}.  New York: Wiley.
 
 Pinheiro, J. C., and Bates, D. M.  (1996) Unconstrained
     parametrizations for variance-covariance matrices.
     \emph{Statistics and Computing} \bold{6}, 289--296.
     
 Pinheiro, J. C., and Bates, D. M.  (2000) \emph{Mixed-effects models in
     S and S-PLUS}.  New York: Springer.
}

\seealso{  \code{\link{nlm}} }

\examples{
library(mvnmle)

data(apple)
mlest(apple)

data(missvals)
mlest(missvals, iterlim=400)

}
\keyword{multivariate}







\eof
\name{mysort}
\alias{mysort}
\title{ Sort a multivariate data matrix according to patterns of missingness.}
\description{
  \code{mysort} sorts a multivariate data matrix so that records with
  identical patterns of missingness are adjacent to one another.
  \code{mysort} is a private function used inside of \code{mlest}.
}
\usage{
mysort(x)
}

\arguments{
  \item{x}{ A multivariate data matrix.  Rows correspond to individual
      records and columns correspond to components of the multivariate vector.}
}

\value{
  \item{sorted.data}{A matrix of the same size as \code{x} but with the
      rows re-arranged so that records with identical patterns of
      missingness are adjacent to one another.}
  \item{freq}{An integer vector giving the number of records in each
      block of rows with a unique pattern of missingness.  The first
      element in \code{freq} counts the number of rows in the top block
      of \code{sorted.data}, and so on.}
}

\seealso{ \code{\link{mlest}} }

\keyword{multivariate}

\eof
