### Name: fake.bc
### Title: Simulated data for a backcross
### Aliases: fake.bc
### Keywords: datasets

### ** Examples

data(fake.bc)
## Don't show: 
fake.bc <- subset(fake.bc,chr=c(2,5,10))
## End Don't show
summary(fake.bc)
plot(fake.bc)

# genome scans without covariates
fake.bc <- calc.genoprob(fake.bc, step=2.5)
out1.nocovar <- scanone(fake.bc, pheno.col=1)
out2.nocovar <- scanone(fake.bc, pheno.col=2)

# genome scans with covariates
ac <- fake.bc$pheno[,c("sex","age")]
ic <- fake.bc$pheno[,"sex"]
out1.covar <- scanone(fake.bc, pheno.col=1,
                      addcovar=ac, intcovar=ic)
out2.covar <- scanone(fake.bc, pheno.col=2,
                      addcovar=ac, intcovar=ic)

# summaries
summary(out1.nocovar, 3)
summary(out1.covar, 3)
summary(out2.nocovar, 3)
summary(out2.covar, 3)

# plots
plot(out1.covar,out1.nocovar,chr=c(2,5,10))
plot(out2.covar,out2.nocovar,chr=c(2,5,10))



