### Name: scantwo
### Title: Two-dimensional genome scan with a two-QTL model
### Aliases: scantwo
### Keywords: models

### ** Examples

data(fake.f2)
## Don't show: 
fake.f2 <- subset(fake.f2, chr=18:19)
## End Don't show
fake.f2 <- calc.genoprob(fake.f2, step=10)
out.2dim <- scantwo(fake.f2, method="hk")
plot(out.2dim)

## Don't show: 
permo.2dim <- scantwo(fake.f2, method="hk", n.perm=2)
## End Don't show## Not run: 
##D permo.2dim <- scantwo(fake.f2, method="hk", n.perm=1000)
## End(Not run)apply(permo.2dim,2,quantile,0.95)

# covariates
data(fake.bc)
fake.bc <- calc.genoprob(fake.bc, step=10)
ac <- fake.bc$pheno[,c("sex","age")]
ic <- fake.bc$pheno[,"sex"]
out <- scantwo(fake.bc, method="hk", pheno.col=1,
               addcovar=ac, intcovar=ic)
plot(out)



