### Name: mcmcFmodel
### Title: Inference in a spatial statistical model
### Aliases: mcmcFmodel


### ** Examples

  # Below is a complete sequence 
  # of commands using Geneland functions

  # we assume that Geneland is installed
  # and loaded by library("Geneland")


  #  first look for a place to write
  #  MCMC outputs
if(.Platform$OS == "unix"){
path.mcmc= "/tmp/"
}

if(.Platform$OS == "windows"){
path.mcmc= "/temp/"
}

 # Simulation of a dataset made of 2 populations
 # 2 loci and 2 alleles per locus
sim = simFmodel(nindiv=100,
          coord.lim=c(0,1,0,1),
          number.nuclei=2,
          nloc=5,
          nall=c(5,5,5,5,5),
          npop=2,
          drift=c(.3,.3),
          plots=FALSE,
          ploth=FALSE,
          seed=123)

  # First run of MCMC algorithm
  # in order to get the posterior mode of the number of populations
mcmcFmodel(sim$coordinates,sim$genotypes,sim$allele.numbers,
           path.mcmc=path.mcmc,
           rate.max=100,
           delta.coord=0,
           npopmin=1,
           npopinit=5,
           npopmax=10,
           nb.nuclei.max=200,
           nit=10000,
           thinning=10,
           freq.model="Dirichlet",
           varnpop=TRUE,
           spatial=TRUE)

  # Trace of number of populations
  # Should display a mode at 2
Plotnpop(path.mcmc)

 # Then re-run the chain with fixed number of populations
mcmcFmodel(sim$coordinates,sim$genotypes,sim$allele.numbers,
           path.mcmc=path.mcmc,
           rate.max=100,
           delta.coord=0,
           npopmin=1,
           npopinit=2,
           npopmax=2,
           nb.nuclei.max=200,
           nit=5000,
           thinning=10,
           freq.model="Dirichlet",
           varnpop=FALSE,
           spatial=TRUE)

   # Post-processing the chain 
PostProcessChain(sim$coordinates,sim$genotypes,sim$allele.numbers,
                  path.mcmc=path.mcmc,
                  nxdom=50,
                  nydom=50,
                  burnin=0)

   # Plots allele frequencies of allele #1 at locus  #1 in sub-population  #1
 PlotFreq(sim$allele.numbers,
path.mcmc=path.mcmc,ipop=1,iloc=1,iall=1)

   # Map of posterior probabilites
   # of population membership
 PlotTessellation(sim$coordinates,path.mcmc=path.mcmc)

   # Map of posterior mode 
   # of population membership
 PosteriorMode(sim$coordinates,path.mcmc=path.mcmc,
               write=FALSE,plotit=TRUE)






