chisq.plot             package:mvoutlier             R Documentation

_C_h_i-_S_q_u_a_r_e _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     The function chisq.plot plots the ordered robust mahalanobis
     distances of the data against the quantiles of the Chi-squared
     distribution. By user interaction this plotting  is iterated each
     time leaving out the observation with the greatest distance.

_U_s_a_g_e:

     chisq.plot(x, quan=1/2, ask=TRUE, ...)

_A_r_g_u_m_e_n_t_s:

       x: matrix or data.frame containing the data

    quan: amount of observations which are used for mcd estimations. 
          has to be between 0.5 and 1, default ist 0.5

     ask: logical. specifies whether user interacton is allowed or not.
          default is TRUE

     ...: additional graphical parameters

_D_e_t_a_i_l_s:

     The function chisq.plot plots the ordered robust mahalanobis
     distances of the data  against the quantiles of the Chi-squared
     distribution. If the data is normal distributed  these values
     should approximately correspond to each other, so outliers can be
     detected  visually. By user interaction this procedure is
     repeated, each time leaving out the  observation with the greatest
     distance (the number of the observation is printed on the 
     console). This method can be seen as an iterativ deletion of
     outliers until a straight  line appears.

_V_a_l_u_e:

outliers: Each time an observation is dropped, its index is added to a
          vector named outliers, which is accessible within the global
          environment after cancellation of  the function.

_A_u_t_h_o_r(_s):

     Moritz Gschwandtner <e0125439@student.tuwien.ac.at> 
      Peter Filzmoser <P.Filzmoser@tuwien.ac.at> <URL:
     http://www.statistik.tuwien.ac.at/public/filz/>

_R_e_f_e_r_e_n_c_e_s:

     R.G. Garrett (1989). The chi-square plot: a tools for multivariate
     outlier recognition. _Journal of Geochemical Exploration_, 32
     (1/3), 319-341.

_E_x_a_m_p_l_e_s:

     data(humus)
     chisq.plot(log(humus[,c("Co","Cu","Ni")]))
     # The identified outliers are in object "outliers"

