dd.plot              package:mvoutlier              R Documentation

_D_i_s_t_a_n_c_e-_D_i_s_t_a_n_c_e _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     The function dd.plot plots the classical mahalanobis distance of
     the data against the robust  mahalanobis distance based on the mcd
     estimator. Different symbols (see function symbol.plot) and
     colours (see function color.plot) are used depending  on the
     mahalanobis and euclidean distance of the observations (see
     Filzmoser et al., 2005).

_U_s_a_g_e:

     dd.plot(x, quan=1/2, alpha=0.025, ...)

_A_r_g_u_m_e_n_t_s:

       x: matrix or data frame containing the data

    quan: amount of observations which are used for mcd estimations. 
          has to be between 0.5 and 1, default ist 0.5

   alpha: amount of observations used for calculating the adjusted
          quantile (see function arw).

     ...: additional graphical parameters

_V_a_l_u_e:

  md.cla: mahalanobis distances of the observations based on classical
          estimators of location and scatter.

  md.rob: mahalanobis distances of the observations based on robust
          estimators of location and scatter (mcd).

_A_u_t_h_o_r(_s):

     Moritz Gschwandtner <e0125439@student.tuwien.ac.at> 
      Peter Filzmoser <P.Filzmoser@tuwien.ac.at> <URL:
     http://www.statistik.tuwien.ac.at/public/filz/>

_R_e_f_e_r_e_n_c_e_s:

     P. Filzmoser, R.G. Garrett, and C. Reimann (2005). Multivariate
     outlier detection in exploration geochemistry. _Computers &
     Geosciences_. To appear.

_S_e_e _A_l_s_o:

     'symbol.plot', 'color.plot', 'arw', 'covPlot'

_E_x_a_m_p_l_e_s:

     # create data:
     x <- cbind(rnorm(100), rnorm(100))
     y <- cbind(rnorm(10, 3, 1), rnorm(10, 3, 1))
     z <- rbind(x,y)
     # execute:
     dd.plot(z)
     #
     # Identify multivariate outliers for Co-Cu-Ni in humus layer of Kola data:
     data(humus)
     dd.plot(log(humus[,c("Co","Cu","Ni")]))

