map.plot              package:mvoutlier              R Documentation

_P_l_o_t _M_u_l_t_i_v_a_r_i_a_t_e _O_u_t_l_i_e_r_s _i_n _a _M_a_p

_D_e_s_c_r_i_p_t_i_o_n:

     The function map.plot creates a map using geographical
     (x,y)-coordinates.  This is thought for spatially dependent data
     of which coordinates are available.  Multivariate outliers are
     marked.

_U_s_a_g_e:

     map.plot(coord, data, quan=1/2, alpha=0.025, symb=FALSE, ... )

_A_r_g_u_m_e_n_t_s:

   coord: (x,y)-coordinates of the data

    data: matrix or data.frame containing the data.

    quan: amount of observations which are used for mcd estimations. 
          has to be between 0.5 and 1, default ist 0.5

   alpha: amount of observations used for calculating the adjusted
          quantile (see function arw).

    symb: locigal for plotting special symbols (see details).

     ...: additional graphical parameters

_D_e_t_a_i_l_s:

     The function map.plot shows mutlivariate outliers in a map. If
     symb=FALSE (default), only two colors and no special symbols are
     used to  mark multivariate outliers (the outliers are marked red).
      If symb=TRUE different symbols and colors are used.  The symbols
     (cross means big value, circle means little value) are selected
     according to  the robust mahalanobis distance based on the
     adjusted mcd estimator (see function symbol.plot) Different colors
     (red means big value, blue means little value)  according to the
     euclidean distances of the observations (see function color.plot)
     are used. For details see Filzmoser et al. (2005).

_V_a_l_u_e:

       x: original data

      md: robust mahalanobis distances of the data

euclidean: (only if symb=TRUE) euclidean distances of the observations
          according to  the minimum of the data.

_A_u_t_h_o_r(_s):

     Moritz Gschwandtner <e0125439@student.tuwien.ac.at> 
      Peter Filzmoser <P.Filzmoser@tuwien.ac.at> <URL:
     http://www.statistik.tuwien.ac.at/public/filz/>

_R_e_f_e_r_e_n_c_e_s:

     P. Filzmoser, R.G. Garrett, and C. Reimann (2005). Multivariate
     outlier detection in exploration geochemistry. _Computers &
     Geosciences_. To appear.

_S_e_e _A_l_s_o:

     'symbol.plot', 'color.plot', 'arw'

_E_x_a_m_p_l_e_s:

     data(humus) # Load humus data
     xy <- humus[,c("XCOO","YCOO")] # X and Y Coordinates
     myhumus <- log(humus[, c("As", "Cd", "Co", "Cu", "Mg", "Pb", "Zn")])
     map.plot(xy, myhumus, symb=TRUE)

