### Name: pumps
### Title: 10 Power Plant Pumps
### Aliases: pumps
### Keywords: datasets

### ** Examples

data(pumps)
pumps.data <- list(t = pumps$t, x = pumps$x, N = nrow(pumps))
pumps.model <- file.path(.path.package("rbugs"), "bugs/model", "pumps.bug")
file.show(pumps.model)
pumps.inits <- file.path(.path.package("rbugs"), "bugs/inits", "pumps.txt")
file.show(pumps.inits)
inits <- list(dget(pumps.inits))
parameters <- c("theta", "alpha", "beta")

## Not run: 
##D ## The workingDir must be a directory which can be seen by wine
##D ## The nominalWorkingDir gives the directory name recoganizable for
##D ## Windows.
##D ## The full name of the bugs and wine executables need to set.
##D ## In .Renviron, add lines similar to these:
##D ##   BUGS="c:/program files/winbugs14/winbugs14.exe"
##D ##   WINE="/var/scratch/jyan/wine-20040408/wine" 
##D 
##D pumps.sim <- rbugs(data = pumps.data, inits, parameters, 
##D                    pumps.model, n.chains = 1, n.iter = 1000,
##D                    workingDir="/var/scratch/jyan/c/tmp",
##D                    bugsWorkingDir="c:/tmp",
##D                    useWine=TRUE)
## End(Not run)



