### Name: deref
### Title: dereferencing references
### Aliases: deref deref<-
### Keywords: programming

### ** Examples

  # Simple usage example
  x <- cbind(1:5, 1:5)          # take some object
  rx <- as.ref(x)               # wrap it into a reference
  deref(rx)                     # read it through the reference
  deref(rx) <- rbind(1:5, 1:5)  # replace the object in the reference by another one
  deref(rx)[1, ]                # read part of the object
  deref(rx)[1, ] <- 5:1         # replace part of the object
  deref(rx)                     # see the change
  cat("For examples how to pass by references see the Performance test examples at the help pages\n")

 ## Not run: 
##D   ## Performance test examples showing actually passing by reference
##D   # define test size
##D   nmatrix <- 1000   # matrix size of nmatrix by nmatrix
##D   nloop   <- 10     # you might want to use less loops in S+, you might want more in R versions before 1.8
##D 
##D   # Performance test using ref
##D   t1 <- function(){ # outer function
##D     m <- matrix(nrow=nmatrix, ncol=nmatrix)
##D     a <- as.ref(m)
##D       t2(a)
##D     m[1,1]
##D   }
##D   # subsetting deref is slower (by factor 75 slower since R 1.8 compared to previous versions, and much, much slower in S+) ...
##D   t2 <- function(ref){ # inner function
##D     cat("timing", timing.wrapper(
##D       for(i in 1:nloop)
##D         deref(ref)[1,1] <- i
##D     ), "\n")
##D   }
##D   if (is.R())gc()
##D   t1()
##D   # ... than using substitute
##D   t2 <- function(ref){
##D     obj <- as.name(ref$name)
##D     loc <- ref$loc
##D     cat("timing", timing.wrapper(
##D       for(i in 1:nloop)
##D         eval(substitute(x[1,1] <- i, list(x=obj, i=i)), loc)
##D     ), "\n")
##D   }
##D   if (is.R())gc()
##D   t1()
##D 
##D   # Performance test using Object (R only)
##D   # see Henrik Bengtsson package(oo)
##D   Object <- function(){
##D     this <- list(env.=new.env());
##D     class(this) <- "Object";
##D     this;
##D   }
##D   "$.Object" <- function(this, name){
##D     get(name, envir=unclass(this)$env.);
##D   }
##D   "$<-.Object" <- function(this, name, value){
##D     assign(name, value, envir=unclass(this)$env.);
##D     this;
##D   }
##D   # outer function
##D   t1 <- function(){
##D     o <- Object()
##D     o$m <- matrix(nrow=nmatrix, ncol=nmatrix)
##D       t2(o)
##D     o$m[1,1]
##D   }
##D   # subsetting o$m is slower ...
##D   t2 <- function(o){
##D     cat("timing", timing.wrapper(
##D       for(i in 1:nloop)
##D         o$m[1,1] <- i
##D     ), "\n")
##D   }
##D   if (is.R())gc()
##D   t1()
##D   # ... than using substitute
##D   t2 <- function(o){
##D     env <- unclass(o)$env.
##D     cat("timing", timing.wrapper(
##D       for(i in 1:nloop)
##D         eval(substitute(m[1,1] <- i, list(i=i)), env)
##D     ), "\n")
##D   }
##D   if (is.R())gc()
##D   t1()
##D 
##D   
## End(Not run)



