### Name: refdata
### Title: subsettable reference to matrix or data.frame
### Aliases: refdata [.refdata [<-.refdata [[.refdata [[<-.refdata
###   $.refdata $<-.refdata dim.refdata dim<-.refdata dimnames.refdata
###   dimnames<-.refdata print.refdata
### Keywords: programming manip

### ** Examples


  ## Simple usage Example
  x <- cbind(1:5, 5:1)            # take a matrix or data frame
  rx <- refdata(x)                # wrap it into an refdata object
  rx                              # see the autoprinting
  rm(x)                           # delete original to save memory
  rx[]                            # extract all data
  rx[-1, ]                        # extract part of data
  rx2 <- rx[-1, , ref=TRUE]       # create refdata object referencing part of data (only index, no data is duplicated)
  rx2                             # compare autoprinting
  rx2[]                           # extract 'all' data
  rx2[-1, ]                       # extract part of (part of) data
  cat("for more examples look the help pages\n")

 ## Not run: 
##D   # Memory saving demos
##D   square.matrix.size <- 1000
##D   recursion.depth.limit <- 10
##D   non.referenced.matrix <- matrix(1:(square.matrix.size*square.matrix.size), nrow=square.matrix.size, ncol=square.matrix.size)
##D   rownames(non.referenced.matrix) <- paste("a", seq(length=square.matrix.size), sep="")
##D   colnames(non.referenced.matrix) <- paste("b", seq(length=square.matrix.size), sep="")
##D   referenced.matrix <- refdata(non.referenced.matrix)
##D   recurse.nonref <- function(m, depth.limit=10){
##D     x <- m[1,1]   # need read access here to create local copy
##D     gc()
##D     cat("depth.limit=", depth.limit, "  memory.size=", memsize.wrapper(), "\n", sep="")
##D     if (depth.limit)
##D       Recall(m[-1, -1, drop=FALSE], depth.limit=depth.limit-1)
##D     invisible()
##D   }
##D   recurse.ref <- function(m, depth.limit=10){
##D     x <- m[1,1]   # read access, otherwise nothing happens
##D     gc()
##D     cat("depth.limit=", depth.limit, "  memory.size=",  memsize.wrapper(), "\n", sep="")
##D     if (depth.limit)
##D       Recall(m[-1, -1, ref=TRUE], depth.limit=depth.limit-1)
##D     invisible()
##D   }
##D   gc()
##D   memsize.wrapper()
##D   recurse.ref(referenced.matrix, recursion.depth.limit)
##D   gc()
##D    memsize.wrapper()
##D   recurse.nonref(non.referenced.matrix, recursion.depth.limit)
##D   gc()
##D    memsize.wrapper()
##D   rm(recurse.nonref, recurse.ref, non.referenced.matrix, referenced.matrix, square.matrix.size, recursion.depth.limit)
##D   
## End(Not run)
  cat("for even more examples look at regression.test.refdata()\n")
  regression.test.refdata()  # testing correctness of refdata functionality



