### Name: bic.glm
### Title: Bayesian Model Averaging for generalized linear models.
### Aliases: bic.glm bic.glm.data.frame bic.glm.matrix bic.glm.formula
### Keywords: regression models

### ** Examples


### logistic regression
library("MASS")
data(birthwt)
y<- birthwt$lo
x<- data.frame(birthwt[,-1])
x$race<- as.factor(x$race)
x$ht<- (x$ht>=1)+0
x<- x[,-9]
x$smoke <- as.factor(x$smoke)
x$ptl<- as.factor(x$ptl)
x$ht <- as.factor(x$ht)
x$ui <- as.factor(x$ui)

glm.out.FT<- bic.glm(x, y, strict = FALSE, OR = 20, glm.family="binomial", factor.type=TRUE)
summary(glm.out.FT)
imageplot.bma(glm.out.FT)

glm.out.FF<- bic.glm(x, y, strict = FALSE, OR = 20, glm.family="binomial", factor.type=FALSE)
summary(glm.out.FF)
imageplot.bma(glm.out.FF)

glm.out.TT<- bic.glm(x, y, strict = TRUE, OR = 20, glm.family="binomial", factor.type=TRUE)
summary(glm.out.TT)
imageplot.bma(glm.out.TT)

glm.out.TF<- bic.glm(x, y, strict = TRUE, OR = 20, glm.family="binomial", factor.type=FALSE)
summary(glm.out.TF)
imageplot.bma(glm.out.TF)


### Gamma family 
library(survival)
data(veteran)
surv.t<- veteran$time
x<- veteran[,-c(3,4)]
x$celltype<- factor(as.character(x$celltype))
sel<- veteran$status == 0
x<- x[!sel,]
surv.t<- surv.t[!sel]

glm.out.va<- bic.glm(x, y=surv.t, glm.family=Gamma(link="inverse") ,factor.type=FALSE)
summary(glm.out.va)
imageplot.bma(glm.out.va)
plot(glm.out.va)


### Poisson family
### Yates (teeth) data. 

x<- rbind(
    c(0, 0, 0),
    c(0, 1, 0),
    c(1, 0, 0),
    c(1, 1, 1))

y<-c(4, 16, 1, 21)
n<-c(1,1,1,1)

models<- rbind(
    c(1, 1, 0),
    c(1, 1, 1))

glm.out.yates <- bic.glm(x,y,n, glm.family = poisson(), factor.type=FALSE) 
summary(glm.out.yates)

### Gaussian
library(MASS)
data(UScrime)
f<- formula(log(y) ~  log(M)+So+log(Ed)+log(Po1)+log(Po2)+log(LF)+log(M.F)+ 
   log(Pop)+log(NW)+log(U1)+log(U2)+log(GDP)+log(Ineq)+log(Prob)+log(Time) )
glm.out.crime<- bic.glm(f, data = UScrime, glm.family = gaussian()) 
summary(glm.out.crime)
# note the problems with the estimation of the posterior standard deviation 
# (compare with bicreg example)





