### Name: rateplot
### Title: Functions to plot rates from a table classified by age and
###   calendar time (period)
### Aliases: rateplot Aplot Pplot Cplot
### Keywords: hplot

### ** Examples

# Generate some bogus rate data:
age <- seq(30,80,10) + 5
per <- seq(1940,2000,10) + 5
rate.fun <- function( age, per )
            5*exp( ( age-0 ) * ( 140-age ) / 10^3 + ( per - 1950 ) * 0.02 )
Y <- outer( age, per, function( age, per ) rep( 1000, length( age ) ) )
D <- outer( age, per,
                 function( a, p )
                    rpois( rate.fun(a,p), rate.fun(a,p) ) )
rates <- D / Y
rownames( rates ) <- age
colnames( rates ) <- per

par( mfrow=c(2,2), mar=c(3,3,1,1), oma=c(0,3,0,0), mgp=c(3,1,0)/1.6 )
rateplot( rates*10^3, ylab="", ann=TRUE, which=c("AP","AC","PA","CA") )

par( mfrow=c(1,3), mar=c(3,3,1,1), oma=c(0,3,0,0), mgp=c(3,1,0)/1.6 )
rateplot( rates*10^3, ylab="", ann=TRUE, which=c("APC","PA","CA") )



