### Name: HR
### Title: Heart rates of patients on different drug treatments
### Aliases: HR
### Keywords: datasets

### ** Examples

options(contrasts = c(unordered = "contr.SAS", ordered = "contr.poly"))
gplot(HR)
(fm1HR <- lmer(HR ~ Time * Drug + baseHR + (Time|Patient), HR))  # linear trend in time
anova(fm1HR)
## Not run: 
##D fm2HR <- update(fm1HR, weights = varPower(0.5)) # use power-of-mean variance
##D summary(fm2HR)
##D intervals(fm2HR)             # variance function does not seem significant
##D anova(fm1HR, fm2HR)         # confirm with likelihood ratio
## End(Not run)
(fm3HR <- lmer(HR ~ Time + Drug + baseHR + (Time|Patient), HR))
anova(fm3HR)
(fm4HR <- lmer(HR ~ Time + baseHR + (Time|Patient), HR))  # remove Drug term
anova(fm4HR)



