### Name: Multilocation
### Title: A multilocation trial
### Aliases: Multilocation
### Keywords: datasets

### ** Examples

options(contrasts = c(unordered = "contr.SAS", ordered = "contr.poly"))
str(Multilocation)
### Create a Block 
Multilocation$Grp <- with(Multilocation, Block:Location)
(fm1Mult <- lmer(Adj ~ Location * Trt + (1|Grp), Multilocation))
anova(fm1Mult)
(fm2Mult <- lmer(Adj ~ Location + Trt + (1|Grp), Multilocation))
fm3Mult <- lmer(Adj ~ Location + (1|Grp), Multilocation)
fm4Mult <- lmer(Adj ~ Trt + (1|Grp), Multilocation)
fm5Mult <- lmer(Adj ~ 1 + (1|Grp), Multilocation)
anova(fm2Mult)
anova(fm1Mult, fm2Mult, fm3Mult, fm4Mult, fm5Mult)
Multilocation$LocTrt <- with(Multilocation, Location:Trt)
### Treating the location as a random effect
## Not run: 
##D (fm1MultR <- lmer(Adj ~ Trt + (1|LocTrt) + (1|Location) + (1|Grp), Multilocation))
##D #intervals(fm1MultR)
##D anova(fm1MultR)
##D fm2MultR <- lmer(Adj ~ Trt + (Trt - 1|Location) + (1|Block), Multilocation)
##D anova(fm1MultR, fm2MultR)
## End(Not run)



