### Name: read.swms2d.table
### Title: Standard SWMS2D input files
### Aliases: read.swms2d.table
### Keywords: spatial

### ** Examples

##################################################################
## global printing paramters and functions
##################################################################
par(cex=1.5, mar=c(4.2,4,0.2,0.2))
my.legend <- function(lu.x, lu.y, zlim, col, cex=1.5) {
    ## uses already the legend code of R-1.3.0
    cn <- length(col)
    filler <- vector("character", length=(cn-3)/2)
    legend(lu.x, lu.y, y.i=0.04, x.i=0.1, yj=0,
           legend=c(format(zlim[2], dig=2), filler,
             format(mean(zlim), dig=2), filler,
             format(zlim[1], dig=2)),
           lty=1, col=rev(col), cex=cex)
  }

##################################################################
##  SWMS2D, Example 1
##################################################################

path <- paste(system.file(package='SoPhy'), 'swms2d', sep="/")
x <- read.swms2d.table(path)
x$TPrint <- seq(10, 5400, 10)

z <- swms2d(x)$hQ[3, , ]
i <- ((length(x$nCodeM$z) / 2):1) * 2 - 1
image(x=c(0, x$TPrint) / 60, y=x$nCodeM$z[i] - max(x$nCodeM$z),
      z=t(z[i, ]), xlab='time [min]', ylab='z [cm]',
      col=grey(seq(1, 0.15, -0.01)), cex.lab=1.5, cex.axis=1.5)

my.legend(0, -max(x$nC$z[i]), zlim=range(z),
          col=grey(seq(1,0.15,-0.01)))



