### Name: Wimage.info
### Title: Finds key indices related to a 2-d multiresolution
### Aliases: Wimage.info Wimage.i2s Wimage.s2i
### Keywords: spatial

### ** Examples

#Find a basis function.
# For a basis on a 64X64 image with cut.min=8 find a 
# horizontal basis function at second level of resolution in the (4,4)
# position. ( There are 16X16 horizontal basis functions at the 2 nd level
#
Wimage.s2i( i=3,j=2, level=2, flavor=1, m=64, n=64, cut.min=8)-> ind
tmp<- matrix( 0, 64,64)
tmp[ind] <- 1
Wtransform.image( tmp, cut.min=8, inv=TRUE)-> look
image.plot( look)

# A check of Wimage.i2s
Wimage.i2s( ind,m=64, n=64, cut.min=8)
# should get i=3,j=2, level=2, flavor=1

# complete check of functions
 Wimage.i2s( 1:512, cut.min=8, m=16, n=32)-> look
 Wimage.s2i( look, cut.min=8, m=16, n=32, mat=FALSE)-> look2
 sum( look2 - (1:512)) # sum should be zero 

# W transform of John Lennon image
     data(lennon)
     m<- nrow(lennon)
     n<- ncol(lennon)
     look<- Wtransform.image( lennon, cut.min=8)

# get info 
     info<- Wimage.info( n, m, cut.min=8)
# Keep only the coarest level of S,H,V,Di  basis functions coefficients, 
# set the rest to zero. 

tmp<- matrix( 0, m,n)

# fill in smooths
indm<- info$S[1]: info$S[2]
indn<- info$S[3]: info$S[4]
tmp[ indm, indn] <- look[indm, indn]

#horizontals
indm<- info$H[1]: info$H[2]
indn<- info$H[3]: info$H[4]
tmp[ indm, indn] <- look[indm, indn]
#verticals
indm<- info$V[1]: info$V[2]
indn<- info$V[3]: info$V[4]
tmp[ indm, indn] <- look[indm, indn]
#diagonals
indm<- info$Di[1]: info$Di[2]
indn<- info$Di[3]: info$Di[4]
tmp[ indm, indn] <- look[indm, indn]

look2<- Wtransform.image( tmp, cut.min=8, inv=TRUE)
# take a look at (severely) filtered image, Happy Halloween!
set.panel( 2,1)
image( lennon)
image( look2)




