### Encoding: latin1

### Name: coef.mvr
### Title: Extract Information From a Fitted PLSR or PCR Model
### Aliases: coef.mvr model.matrix.mvr
### Keywords: regression multivariate

### ** Examples

data(NIR)
mod <- pcr(y ~ X, data = NIR[NIR$train,], ncomp = 5)
B <- coef(mod, comps = 3, intercept = TRUE)
## A manual predict method:
stopifnot(drop(B[1,,] + NIR$X[!NIR$train,] %*% B[-1,,]) ==
          drop(predict(mod, comps = 3, newdata = NIR[!NIR$train,])))



