### Encoding: latin1

### Name: mvr
### Title: Partial Least Squares and Principal Components Regression
### Aliases: mvr pcr plsr
### Keywords: regression multivariate

### ** Examples

data(NIR)
## Default methods:
NIR.pcr <- pcr(y ~ X, 6, data = NIR, CV = TRUE)
NIR.pls <- plsr(y ~ X, 6, data = NIR, CV = TRUE)

## Alternative methods:
NIR.oscorespls <- mvr(y ~ X, 6, data = NIR, CV = TRUE,
                      method = "oscorespls")
NIR.simpls <- mvr(y ~ X, 6, data = NIR, CV = TRUE,
                  method = "simpls")

data(sensory)
Pn <- scale(sensory$Panel)
Ql <- scale(sensory$Quality)
sens.pcr <- pcr(Ql ~ Pn, ncomp = 4)
sens.pls <- plsr(Ql ~ Pn, ncomp = 4)



