### Encoding: latin1

### Name: plot.mvr
### Title: Plot Method for MVR objects
### Aliases: plot.mvr
### Keywords: regression multivariate hplot

### ** Examples

data(NIR)
nir.pcr <- pcr(y ~ X, ncomp = 9, data = NIR, CV = TRUE)
## Not run: plot(nir.pcr, ncomp = 5) # Plot of cross-validated predictions
## Not run: plot(nir.pcr, "scores") # Score plot
## Not run: plot(nir.pcr, "loadings", comps = 1:3) # The three first loadings
## Not run: plot(nir.pcr, "coef", ncomp = 5) # Coefficients
## Not run: plot(nir.pcr, "val") # RMSEP curves
## Not run: plot(nir.pcr, "val", val.type = "MSEP", estimate = "CV") # CV MSEP



