### Encoding: latin1

### Name: predict.mvr
### Title: Predict Method for PLSR and PCR
### Aliases: predict.mvr
### Keywords: regression multivariate

### ** Examples

data(NIR)
nir.mvr <- mvr(y ~ X, ncomp = 5, data = NIR[NIR$train,])

## Predicted responses for models with 1, 2, 3 and 4 components
pred.resp <- predict(nir.mvr, comps = 1:4, newdata = NIR[!NIR$train,])

## Predicted responses for a single model with components 1, 2, 3, 4
predict(nir.mvr, comps = 1:4, cumulative = FALSE, newdata = NIR[!NIR$train,])

## Predicted scores
predict(nir.mvr, comps = 1:3, type = "scores", newdata = NIR[!NIR$train,])



