### Name: Sample
### Title: Sample Objects
### Aliases: Sample as.Sample is.Sample
### Keywords: classes

### ** Examples
## Not run: waveLeft <- 2*((seq(0,80,length=88200)%%1^2)-.5)
##D s <- as.Sample(waveLeft,44100,16)
##D play(s) # a mono sample
##D 
##D waveRight <- waveLeft[88200:1]
##D s <- as.Sample(rbind(waveLeft,waveRight),44100,16)
##D play(s) # a stereo Sample
##D 
##D # How to use is.Sample to allow both a Sample object and a filename
##D # as an argument:
##D s <- anyargument
##D sampletest <- is.Sample(s, argname="s ")
##D if (!sampletest$test) stop(sampletest$error) #no valid argument
##D t <- loadSample(s,filecheck=FALSE)
##D # If s is Sample object, loadSample will return it immediately.
##D # If s is a string, the Sample object will be loaded from disk.
##D # No check for existance of the file will be performed since this
##D # was already tested in is.Sample.
##D #
##D # Now s is a Sample object, continue with routine.
## End(Not run)



