### R code from vignette source 'Categorical-FDA-Tutorial.Rnw'

###################################################
### code chunk number 1: Categorical-FDA-Tutorial.Rnw:14-15
###################################################
library(Actigraphy)


###################################################
### code chunk number 2: Categorical-FDA-Tutorial.Rnw:20-25
###################################################
data(clinic_29pt_ahi)
data(act_29pt)
###
covariate <- clinic_29pt_ahi
activity <- act_29pt


###################################################
### code chunk number 3: Categorical-FDA-Tutorial.Rnw:31-34
###################################################
covariate <- na.omit(covariate)
activity <- as.matrix(activity[,-1])
colnames(activity) <- sub("X", "", colnames(activity))


###################################################
### code chunk number 4: Categorical-FDA-Tutorial.Rnw:39-44
###################################################
covariate$ahicat <- as.factor(
	ifelse(covariate$AHI >= 0 & covariate$AHI <= 5, 1, 
	ifelse(covariate$AHI > 5 & covariate$AHI <= 15, 2,
	ifelse(covariate$AHI > 15 & covariate$AHI <= 30, 3,
	ifelse(covariate$AHI > 30, 4, 0)))))


###################################################
### code chunk number 5: Categorical-FDA-Tutorial.Rnw:50-52
###################################################
matchid <- fda.matchid(activity, covariate[,-2], type="factor", 
	grouplab=c("normal", "mild", "moderate", "severe"))


###################################################
### code chunk number 6: Categorical-FDA-Tutorial.Rnw:60-64
###################################################
L <- nrow(activity)
FDinterest <- fda.smoothdata(matchid, nbasis=9, basistype="Fourier")
ts.plot(predict(FDinterest$fd$fd, c(1:L)), 
	main="Smoothed Activity Data")


###################################################
### code chunk number 7: Categorical-FDA-Tutorial.Rnw:69-70
###################################################
geftinterest <- flm_cate(FDinterest, nbasis=9, basistype="Fourier")


###################################################
### code chunk number 8: Categorical-FDA-Tutorial.Rnw:80-84
###################################################
ypred <- as.vector(geftinterest$freg$yhatfdobj$y)
ylim <- c(0, max(ypred) + 100)
lb <- c("Midnight", "6AM", "Noon", "6PM", "Midnight") 
xat <- c(0, L/4, L/2, 3*L/4, L)


###################################################
### code chunk number 9: Categorical-FDA-Tutorial.Rnw:89-92
###################################################
cat_flm_plot(smoothdata=FDinterest, matchresults=matchid, 
	flmresults=geftinterest, ftest=TRUE, nperm=5, lb=lb, xat=xat, 
	varname="Var of Interest", col=c(1:4), ylim=ylim, L=L)


