### R code from vignette source 'Continuous-FDA-Tutorial.Rnw'

###################################################
### code chunk number 1: Continuous-FDA-Tutorial.Rnw:14-15
###################################################
library(Actigraphy)


###################################################
### code chunk number 2: Continuous-FDA-Tutorial.Rnw:20-25
###################################################
data(clinic_29pt_ahi)
data(act_29pt)
###
covariate <- clinic_29pt_ahi
activity <- act_29pt


###################################################
### code chunk number 3: Continuous-FDA-Tutorial.Rnw:31-34
###################################################
covariate <- na.omit(covariate)
activity <- as.matrix(activity[,-1])
colnames(activity) <- sub("X", "", colnames(activity))


###################################################
### code chunk number 4: Continuous-FDA-Tutorial.Rnw:39-40
###################################################
matchid <- fda.matchid(activity, covariate, type="contin")


###################################################
### code chunk number 5: Continuous-FDA-Tutorial.Rnw:48-52
###################################################
L <- nrow(activity)
FDinterest <- fda.smoothdata(matchid, nbasis=9, basistype="Fourier")
ts.plot(predict(FDinterest$fd$fd, c(1:L)), 
	main="Smoothed Activity Data")


###################################################
### code chunk number 6: Continuous-FDA-Tutorial.Rnw:57-58
###################################################
geftFDcont <- flm_cate(FDinterest, nbasis=9, basistype="Fourier")


###################################################
### code chunk number 7: Continuous-FDA-Tutorial.Rnw:71-80
###################################################
predy <- as.vector(geftFDcont$freg$yhatfdobj$y)
###
xlim <- c(0, L) 
ylim <- c(min(predy), max(predy) + 100) 
lb <- c("Midnight", "6AM", "Noon", "6PM", "Midnight") 
xat <- c(0, L/4, L/2, 3*L/4, L)
###
legendx <- 0
legendy <- max(predy) - 100


###################################################
### code chunk number 8: Continuous-FDA-Tutorial.Rnw:85-89
###################################################
cont_flm_plot(smoothdata=FDinterest, matchresults=matchid, 
	flmresults=geftFDcont, xlim=xlim, ylim=ylim, ftest=TRUE, 
	nperm=10, lb=lb, xat=xat, legendx=legendx, 
	legendy=legendy, L=L)


