### R code from vignette source 'CLAG-tutorial.Rnw'

###################################################
### code chunk number 1: CLAG-tutorial.Rnw:47-48
###################################################
library(CLAG)


###################################################
### code chunk number 2: CLAG-tutorial.Rnw:53-55
###################################################
data(DIM128_subset, package="CLAG")
RES <- CLAG.clust(DIM128_subset)


###################################################
### code chunk number 3: CLAG-tutorial.Rnw:60-64
###################################################
PCA <- prcomp(DIM128_subset)
clusterColors <- c("black", rainbow(RES$ncluster))
plot(PCA$x[,1], PCA$x[,2], col=clusterColors[RES$cluster+1],
     main=paste(RES$nclusters, "clusters"))


###################################################
### code chunk number 4: CLAG-tutorial.Rnw:79-82
###################################################
data(GLOBINE, package="CLAG")
M <- GLOBINE$M
RES <- CLAG.clust(M, delta=0.2, threshold=0.5, analysisType=3)


###################################################
### code chunk number 5: CLAG-tutorial.Rnw:86-93
###################################################
o <- order(RES$cluster)
M2 <- M[o,o]

clusterColors <- c("black", rainbow(RES$nclusters))[RES$cluster[o]+1]
colorScale <- colorRampPalette(c("blue", "green","yellow","red","darkred"))(1000)
heatmap(M2, symm=TRUE, Colv=NA, Rowv=NA, scale="none", col=colorScale,
        ColSideColors=clusterColors, RowSideColors=clusterColors)


