### R code from vignette source 'MAMA.rnw'

###################################################
### code chunk number 1: lib
###################################################
rm(list=ls(all=TRUE))
options(width=60)
library(MAMA)
data(ColonData)
ColonData


###################################################
### code chunk number 2: MAMA.rnw:48-49
###################################################
pval<- metaMA(ColonData, "MSIstatus", which ="pval")


###################################################
### code chunk number 3: MAMA.rnw:78-79
###################################################
es <- metaMA(ColonData, "MSIstatus", which = "ES")


###################################################
### code chunk number 4: MAMA.rnw:84-85
###################################################
es2<-ES.GeneMeta(ColonData, "MSIstatus", nperm = 100)


###################################################
### code chunk number 5: SOGLperform
###################################################
SOGL.res <- performSOGL(ColonData, varname = "MSIstatus", 
test = "FCH", B = 100, which=c("score", "empirical"), 
min.weight = 1e-05, two.sided = TRUE )


###################################################
### code chunk number 6: MAMA.rnw:143-144
###################################################
plot(SOGL.res, "alpha selection") 


###################################################
### code chunk number 7: MAMA.rnw:148-149
###################################################
plot(SOGL.res, "density") 


###################################################
### code chunk number 8: MAMA.rnw:153-154
###################################################
plot(SOGL.res, "empirical CI")


###################################################
### code chunk number 9: MAMA.rnw:176-178
###################################################
rp <- RankProduct(ColonData, "MSIstatus", num.perm = 50,
 gene.names = rownames(GEDM(ColonData)[[1]]) )


###################################################
### code chunk number 10: Zdata
###################################################
ColonData


###################################################
### code chunk number 11: Zdeg
###################################################
z.stat<-posterior.mean(ColonData, "MSIstatus", nsamp=5)


###################################################
### code chunk number 12: MAMA.rnw:201-202
###################################################
head(round(z.stat,3))


###################################################
### code chunk number 13: MAMA.rnw:226-228
###################################################
vm <- VennMapper(ColonData, varname="MSIstatus", cutoff=1)
vm


###################################################
### code chunk number 14: MAMA.rnw:252-254
###################################################
map <- MAP.Matches(ColonData, "MSIstatus", t.cutoff = "95.00%", 
nperm = 100, sig.col = "p.col.strong")


###################################################
### code chunk number 15: MAMA.rnw:286-288
###################################################
metra<-METRADISC(ColonData, "MSIstatus", nperm = 1000)
str(metra)


###################################################
### code chunk number 16: MAMA.rnw:297-302
###################################################
lists<-join.DEG(pval, es, es2, SOGL.res, rp, z.stat,
  map,  cutoff=0.05)
names(lists)<-c("PvalCom", "ESCom","ESCom2","OrderedList",
"RankProduct", "Z-stat","MAP")
summary(lists)


###################################################
### code chunk number 17: MAMA.rnw:305-307
###################################################
MAT<-make.matrix(lists)
MAT[1:5,1:5]


###################################################
### code chunk number 18: MAMA.rnw:312-313
###################################################
metaheat(MAT, legend=1, col=c("red3", "royalblue2"))


###################################################
### code chunk number 19: MAMA.rnw:318-321
###################################################
metaheat2(MAT, col=c("red3", "royalblue2"), legend.names=c("DEG",
"noDEG"), discrete=TRUE, trace="none", 
dendrogram="none", cexCol=0.9)


###################################################
### code chunk number 20: MAMA.rnw:326-327
###################################################
dim(MAT)


###################################################
### code chunk number 21: MAMA.rnw:332-335
###################################################
n.met<-apply(MAT,1,sum)
hist(n.met, main="", xlab="Number of methods", 
ylab="Number of genes", xlim=c(1,8))


###################################################
### code chunk number 22: MAMA.rnw:340-341
###################################################
dim(MAT[n.met>5,])


###################################################
### code chunk number 23: MAMA.rnw:345-347
###################################################
n.gen<-apply(MAT,2,sum)
barplot(n.gen, cex.names=0.8, las=2)


###################################################
### code chunk number 24: MAMA.rnw:351-353
###################################################
TAB<-conting.tab(lists)
TAB[1:5,1:5]


###################################################
### code chunk number 25: MAMA.rnw:361-367
###################################################
results<-join.results(pval, es, es2, SOGL.res, rp, z.stat, map, metra)

gene<-metagene("203008_x_at",results)
names(gene)<-c("pval","es.metaMA", "es.GeneMeta", "SOGL", "RP",
 "z.stat", "MAP", "METRADISC")
gene


###################################################
### code chunk number 26: MAMA.rnw:371-372
###################################################
plotgene(gene, datalabels=c("denmark", "australia", "japan", "combined"))


