/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;

public final class AveragingPreferenceInferrer
implements PreferenceInferrer {
    private static final Float ZERO = Float.valueOf(0.0f);
    private final DataModel dataModel;
    private final Cache<Long, Float> averagePreferenceValue;

    public AveragingPreferenceInferrer(DataModel dataModel) throws TasteException {
        this.dataModel = dataModel;
        PrefRetriever retriever = new PrefRetriever();
        this.averagePreferenceValue = new Cache<Long, Float>(retriever, dataModel.getNumUsers());
        this.refresh(null);
    }

    @Override
    public float inferPreference(long userID, long itemID) throws TasteException {
        return this.averagePreferenceValue.get(userID).floatValue();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.averagePreferenceValue.clear();
    }

    public String toString() {
        return "AveragingPreferenceInferrer";
    }

    private final class PrefRetriever
    implements Retriever<Long, Float> {
        private PrefRetriever() {
        }

        @Override
        public Float get(Long key) throws TasteException {
            FullRunningAverage average = new FullRunningAverage();
            PreferenceArray prefs = AveragingPreferenceInferrer.this.dataModel.getPreferencesFromUser(key);
            int size = prefs.length();
            if (size == 0) {
                return ZERO;
            }
            for (int i = 0; i < size; ++i) {
                average.addDatum(prefs.getValue(i));
            }
            return Float.valueOf((float)average.getAverage());
        }
    }
}

