/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.math.list.IntArrayList;

public final class IntTuple
implements WritableComparable<IntTuple> {
    private IntArrayList tuple = new IntArrayList();

    public IntTuple() {
    }

    public IntTuple(int firstEntry) {
        this.add(firstEntry);
    }

    public IntTuple(Iterable<Integer> entries) {
        for (Integer entry : entries) {
            this.add(entry);
        }
    }

    public IntTuple(int[] entries) {
        for (int entry : entries) {
            this.add(entry);
        }
    }

    public void add(int entry) {
        this.tuple.add(entry);
    }

    public int at(int index) {
        return this.tuple.get(index);
    }

    public int replaceAt(int index, int newInteger) {
        int old = this.tuple.get(index);
        this.tuple.set(index, newInteger);
        return old;
    }

    public IntArrayList getEntries() {
        return new IntArrayList(this.tuple.elements());
    }

    public int length() {
        return this.tuple.size();
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntTuple other = (IntTuple)obj;
        return !(this.tuple == null ? other.tuple != null : !this.tuple.equals((Object)other.tuple));
    }

    public void readFields(DataInput in) throws IOException {
        int len = in.readInt();
        this.tuple = new IntArrayList(len);
        IntWritable value = new IntWritable();
        for (int i = 0; i < len; ++i) {
            value.readFields(in);
            this.tuple.add(value.get());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.tuple.size());
        IntWritable value = new IntWritable();
        for (int entry : this.tuple.elements()) {
            value.set(entry);
            value.write(out);
        }
    }

    public int compareTo(IntTuple otherTuple) {
        int thisLength = this.length();
        int otherLength = otherTuple.length();
        int min = Math.min(thisLength, otherLength);
        for (int i = 0; i < min; ++i) {
            int b;
            int a = this.tuple.get(i);
            if (a < (b = otherTuple.at(i))) {
                return -1;
            }
            if (a <= b) continue;
            return 1;
        }
        if (thisLength < otherLength) {
            return -1;
        }
        if (thisLength > otherLength) {
            return 1;
        }
        return 0;
    }
}

