/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public final class ClassUtils {
    private static final Class<?>[] NO_TYPES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private static final Method CLONE_METHOD;

    private ClassUtils() {
    }

    public static <T> T loadInstanceOf(Class<T> clazz) {
        return ClassUtils.loadInstanceOf(clazz.getName(), clazz);
    }

    public static <T> T loadInstanceOf(Class<T> clazz, Class<?>[] constructorTypes, Object[] constructorArgs) {
        return ClassUtils.loadInstanceOf(clazz.getName(), clazz, constructorTypes, constructorArgs);
    }

    public static <T> T loadInstanceOf(String implClassName, Class<T> superClass) {
        return ClassUtils.loadInstanceOf(implClassName, superClass, NO_TYPES, NO_ARGS);
    }

    public static <T> T loadInstanceOf(String implClassName, Class<T> superClass, Class<?>[] constructorTypes, Object[] constructorArgs) {
        return ClassUtils.doLoadInstanceOf(implClassName, superClass, constructorTypes, constructorArgs, ClassUtils.class.getClassLoader());
    }

    public static <T> T loadFromRemote(String implClassName, Class<T> superClass, URL url) {
        URLClassLoader urlClassloader = new URLClassLoader(new URL[]{url}, ClassUtils.class.getClassLoader());
        return ClassUtils.doLoadInstanceOf(implClassName, superClass, NO_TYPES, NO_ARGS, urlClassloader);
    }

    public static <T> Class<? extends T> loadClass(String implClassName, Class<T> superClass) {
        return ClassUtils.doLoadClass(implClassName, superClass, ClassUtils.class.getClassLoader());
    }

    private static <T> Class<? extends T> doLoadClass(String implClassName, Class<T> superClass, ClassLoader classLoader) {
        try {
            return Class.forName(implClassName, true, classLoader).asSubclass(superClass);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", cnfe);
        }
    }

    private static <T> T doLoadInstanceOf(String implClassName, Class<T> superClass, Class<?>[] constructorTypes, Object[] constructorArgs, ClassLoader classLoader) {
        try {
            Class<T> configClass = ClassUtils.doLoadClass(implClassName, superClass, classLoader);
            Constructor<T> constructor = configClass.getConstructor(constructorTypes);
            return constructor.newInstance(constructorArgs);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", nsme);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException("Could not instantiate " + superClass + " due to exception", ite.getCause());
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", iae);
        }
    }

    public static boolean classExists(String implClassName) {
        try {
            Class.forName(implClassName);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public static Field loadField(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalStateException("Can't access " + clazz.getSimpleName() + '.' + fieldName, nsfe);
        }
        field.setAccessible(true);
        return field;
    }

    public static <T extends Cloneable> T clone(T original) {
        try {
            Cloneable clone = (Cloneable)CLONE_METHOD.invoke(original, new Object[0]);
            return (T)clone;
        }
        catch (IllegalAccessException iae) {
            throw new AssertionError((Object)iae);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException(ite.getCause());
        }
    }

    static {
        try {
            CLONE_METHOD = Object.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        CLONE_METHOD.setAccessible(true);
    }
}

