/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.myrrix.common.ClassUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.online.MultiRescorerProvider;
import net.myrrix.online.RescorerProvider;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;

public abstract class AbstractRescorerProvider
implements RescorerProvider {
    private static final Pattern COMMA = Pattern.compile(",");

    @Override
    public IDRescorer getRecommendRescorer(long[] userIDs, MyrrixRecommender recommender, String ... args) {
        return null;
    }

    @Override
    public IDRescorer getRecommendToAnonymousRescorer(long[] itemIDs, MyrrixRecommender recommender, String ... args) {
        return null;
    }

    @Override
    public IDRescorer getMostPopularItemsRescorer(MyrrixRecommender recommender, String ... args) {
        return null;
    }

    @Override
    public Rescorer<LongPair> getMostSimilarItemsRescorer(MyrrixRecommender recommender, String ... args) {
        return null;
    }

    public static RescorerProvider loadRescorerProviders(String classNamesString, URL url) {
        if (classNamesString == null || classNamesString.isEmpty()) {
            return null;
        }
        String[] classNames = COMMA.split(classNamesString);
        if (classNames.length == 1) {
            return AbstractRescorerProvider.loadOneRescorerProvider(classNames[0], url);
        }
        ArrayList<RescorerProvider> providers = Lists.newArrayListWithCapacity(classNames.length);
        for (String className : classNames) {
            providers.add(AbstractRescorerProvider.loadOneRescorerProvider(className, url));
        }
        return new MultiRescorerProvider(providers);
    }

    private static RescorerProvider loadOneRescorerProvider(String className, URL url) {
        if (url == null) {
            return ClassUtils.loadInstanceOf(className, RescorerProvider.class);
        }
        return ClassUtils.loadFromRemote(className, RescorerProvider.class, url);
    }
}

