/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;

public final class MultiLongPairRescorer
implements Rescorer<LongPair> {
    private final Rescorer<LongPair>[] rescorers;

    public MultiLongPairRescorer(Rescorer<LongPair> ... rescorers) {
        Preconditions.checkNotNull(rescorers);
        Preconditions.checkState(rescorers.length > 0);
        this.rescorers = rescorers;
    }

    public MultiLongPairRescorer(List<Rescorer<LongPair>> rescorers) {
        Preconditions.checkNotNull(rescorers);
        Preconditions.checkState(!rescorers.isEmpty());
        Rescorer[] newArray = new Rescorer[rescorers.size()];
        this.rescorers = rescorers.toArray(newArray);
    }

    @Override
    public double rescore(LongPair itemIDs, double value) {
        for (Rescorer<LongPair> rescorer : this.rescorers) {
            if (!Double.isNaN(value = rescorer.rescore(itemIDs, value))) continue;
            return Double.NaN;
        }
        return value;
    }

    @Override
    public boolean isFiltered(LongPair itemIDs) {
        for (Rescorer<LongPair> rescorer : this.rescorers) {
            if (!rescorer.isFiltered(itemIDs)) continue;
            return true;
        }
        return false;
    }
}

