/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;

public final class InMemoryRealm
extends RealmBase {
    public static final String NAME = "Myrrix";
    public static final String AUTH_ROLE = "myrrix-user";
    private final Map<String, GenericPrincipal> principals = Maps.newHashMap();

    @Override
    public String getInfo() {
        return InMemoryRealm.class.getSimpleName() + "/1.0";
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        GenericPrincipal principal = this.principals.get(username);
        boolean validated = false;
        if (principal != null && credentials != null) {
            validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(principal.getPassword()) : this.digest(credentials).equals(principal.getPassword());
        }
        return validated ? principal : null;
    }

    void addUser(String username, String password) {
        this.principals.put(username, new GenericPrincipal(username, password, Collections.singletonList(AUTH_ROLE)));
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String getPassword(String username) {
        GenericPrincipal principal = this.principals.get(username);
        return principal == null ? null : principal.getPassword();
    }

    @Override
    protected Principal getPrincipal(String username) {
        return this.principals.get(username);
    }
}

