/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.CliFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLContext;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import net.myrrix.common.ClassUtils;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.log.MemoryHandler;
import net.myrrix.common.signal.SignalManager;
import net.myrrix.common.signal.SignalType;
import net.myrrix.online.io.ResourceRetriever;
import net.myrrix.web.DoSFilter;
import net.myrrix.web.InMemoryRealm;
import net.myrrix.web.InitListener;
import net.myrrix.web.RunnerArgs;
import net.myrrix.web.RunnerConfiguration;
import net.myrrix.web.error_jspx;
import net.myrrix.web.index_jspx;
import net.myrrix.web.servlets.AllItemIDsServlet;
import net.myrrix.web.servlets.AllUserIDsServlet;
import net.myrrix.web.servlets.BecauseServlet;
import net.myrrix.web.servlets.EstimateForAnonymousServlet;
import net.myrrix.web.servlets.EstimateServlet;
import net.myrrix.web.servlets.IngestServlet;
import net.myrrix.web.servlets.ItemClusterServlet;
import net.myrrix.web.servlets.LogServlet;
import net.myrrix.web.servlets.MostPopularItemsServlet;
import net.myrrix.web.servlets.PreferenceServlet;
import net.myrrix.web.servlets.ReadyServlet;
import net.myrrix.web.servlets.RecommendServlet;
import net.myrrix.web.servlets.RecommendToAnonymousServlet;
import net.myrrix.web.servlets.RecommendToManyServlet;
import net.myrrix.web.servlets.RefreshServlet;
import net.myrrix.web.servlets.SimilarityServlet;
import net.myrrix.web.servlets.SimilarityToItemServlet;
import net.myrrix.web.servlets.TagItemServlet;
import net.myrrix.web.servlets.TagUserServlet;
import net.myrrix.web.servlets.UserClusterServlet;
import net.myrrix.web.som_jspx;
import net.myrrix.web.status_jspx;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.DigestAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.JasperListener;
import org.apache.catalina.core.JreMemoryLeakPreventionListener;
import org.apache.catalina.core.ThreadLocalLeakPreventionListener;
import org.apache.catalina.deploy.ApplicationListener;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.Tomcat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Runner
implements Callable<Boolean>,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(Runner.class);
    private static final int[] ERROR_PAGE_STATUSES = new int[]{400, 401, 404, 405, 500, 501, 503};
    private final RunnerConfiguration config;
    private Tomcat tomcat;
    private final File noSuchBaseDir;
    private boolean closed;

    public Runner(RunnerConfiguration config) {
        Preconditions.checkNotNull(config);
        this.config = config;
        this.noSuchBaseDir = Files.createTempDir();
        this.noSuchBaseDir.deleteOnExit();
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public static void main(String[] args) throws Exception {
        RunnerConfiguration config;
        try {
            RunnerArgs runnerArgs = CliFactory.parseArguments(RunnerArgs.class, args);
            config = Runner.buildConfiguration(runnerArgs);
        }
        catch (ArgumentValidationException ave) {
            Runner.printHelp(ave.getMessage());
            return;
        }
        final Runner runner = new Runner(config);
        runner.call();
        SignalManager.register(new Runnable(){

            @Override
            public void run() {
                runner.close();
            }
        }, SignalType.INT, SignalType.TERM);
        runner.await();
        runner.close();
    }

    private static RunnerConfiguration buildConfiguration(RunnerArgs runnerArgs) {
        boolean hasAllPartitions;
        boolean bucketSet;
        RunnerConfiguration config = new RunnerConfiguration();
        config.setPort(runnerArgs.getPort());
        config.setSecurePort(runnerArgs.getSecurePort());
        config.setContextPath(runnerArgs.getContextPath());
        config.setReadOnly(runnerArgs.isReadOnly());
        config.setLocalInputDir(runnerArgs.getLocalInputDir());
        boolean instanceIDSet = runnerArgs.getInstanceID() != null;
        boolean bl = bucketSet = runnerArgs.getBucket() != null;
        if (instanceIDSet != bucketSet) {
            throw new ArgumentValidationException("Must set both --instanceID and --bucket together");
        }
        if (instanceIDSet) {
            config.setInstanceID(runnerArgs.getInstanceID());
            config.setBucket(runnerArgs.getBucket());
        }
        config.setUserName(runnerArgs.getUserName());
        config.setPassword(runnerArgs.getPassword());
        config.setConsoleOnlyPassword(runnerArgs.isConsoleOnlyPassword());
        config.setKeystoreFile(runnerArgs.getKeystoreFile());
        config.setKeystorePassword(runnerArgs.getKeystorePassword());
        config.setHostRequestLimit(runnerArgs.getHostRequestLimit());
        config.setRescorerProviderClassName(runnerArgs.getRescorerProviderClass());
        config.setClientThreadClassName(runnerArgs.getClientThreadClass());
        boolean hasPartition = runnerArgs.getPartition() != null;
        boolean bl2 = hasAllPartitions = runnerArgs.getAllPartitions() != null;
        if (hasPartition != hasAllPartitions) {
            throw new ArgumentValidationException("Must set --partition and --allPartitions together");
        }
        if (hasPartition) {
            config.setAllPartitionsSpecification(runnerArgs.getAllPartitions());
            config.setPartition(runnerArgs.getPartition());
        }
        return config;
    }

    @Override
    public Boolean call() throws IOException {
        MemoryHandler.setSensibleLogFormat();
        java.util.logging.Logger.getLogger("").addHandler(new MemoryHandler());
        Tomcat tomcat = new Tomcat();
        Connector connector = this.makeConnector();
        this.configureTomcat(tomcat, connector);
        this.configureEngine(tomcat.getEngine());
        Runner.configureServer(tomcat.getServer());
        Runner.configureHost(tomcat.getHost());
        Context context = this.makeContext(tomcat, this.noSuchBaseDir, connector.getPort());
        if (this.config.getHostRequestLimit() != null) {
            Runner.addFilter(context, new DoSFilter(), "/*", Collections.singletonMap("maxAccessPerHostPerMin", this.config.getHostRequestLimit().toString()));
        }
        Runner.addServlet(context, new RecommendServlet(), "/recommend/*");
        Runner.addServlet(context, new RecommendToManyServlet(), "/recommendToMany/*");
        Runner.addServlet(context, new RecommendToAnonymousServlet(), "/recommendToAnonymous/*");
        Runner.addServlet(context, new SimilarityServlet(), "/similarity/*");
        Runner.addServlet(context, new SimilarityToItemServlet(), "/similarityToItem/*");
        Runner.addServlet(context, new EstimateServlet(), "/estimate/*");
        Runner.addServlet(context, new EstimateForAnonymousServlet(), "/estimateForAnonymous/*");
        Runner.addServlet(context, new BecauseServlet(), "/because/*");
        Runner.addServlet(context, new ReadyServlet(), "/ready/*");
        Runner.addServlet(context, new AllUserIDsServlet(), "/user/allIDs/*");
        Runner.addServlet(context, new AllItemIDsServlet(), "/item/allIDs/*");
        Runner.addServlet(context, new UserClusterServlet(), "/user/clusters/*");
        Runner.addServlet(context, new ItemClusterServlet(), "/item/clusters/*");
        Runner.addServlet(context, new MostPopularItemsServlet(), "/mostPopularItems/*");
        if (!this.config.isReadOnly()) {
            Runner.addServlet(context, new PreferenceServlet(), "/pref/*");
            Runner.addServlet(context, new TagUserServlet(), "/tag/user/*");
            Runner.addServlet(context, new TagItemServlet(), "/tag/item/*");
            Wrapper ingestWrapper = Runner.addServlet(context, new IngestServlet(), "/ingest/*");
            ingestWrapper.setMultipartConfigElement(new MultipartConfigElement("/tmp"));
            Runner.addServlet(context, new RefreshServlet(), "/refresh/*");
        }
        Runner.addServlet(context, new index_jspx(), "/index.jspx");
        Runner.addServlet(context, new status_jspx(), "/status.jspx");
        Runner.addServlet(context, new error_jspx(), "/error.jspx");
        Runner.addServlet(context, new som_jspx(), "/som.jspx");
        Runner.addServlet(context, new LogServlet(), "/log.txt");
        try {
            tomcat.start();
        }
        catch (LifecycleException le) {
            throw new IOException(le);
        }
        this.tomcat = tomcat;
        return Boolean.TRUE;
    }

    public void await() {
        this.tomcat.getServer().await();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.tomcat != null) {
                try {
                    this.tomcat.stop();
                    this.tomcat.destroy();
                }
                catch (LifecycleException le) {
                    log.warn("Unexpected error while stopping", le);
                }
                if (!IOUtils.deleteRecursively(this.noSuchBaseDir)) {
                    log.info("Could not delete {}", (Object)this.noSuchBaseDir);
                }
            }
        }
    }

    private static void printHelp(String message) {
        System.out.println();
        System.out.println("Myrrix Serving Layer. Copyright Myrrix Ltd, except for included ");
        System.out.println("third-party open source software. Full details of licensing at http://myrrix.com/legal/");
        System.out.println();
        if (message != null) {
            System.out.println(message);
            System.out.println();
        }
    }

    private void configureTomcat(Tomcat tomcat, Connector connector) {
        tomcat.setBaseDir(this.noSuchBaseDir.getAbsolutePath());
        tomcat.setConnector(connector);
        tomcat.getService().addConnector(connector);
    }

    private void configureEngine(Engine engine) {
        String userName = this.config.getUserName();
        String password = this.config.getPassword();
        if (userName != null && password != null) {
            InMemoryRealm realm = new InMemoryRealm();
            realm.addUser(userName, password);
            engine.setRealm(realm);
        }
    }

    private static void configureServer(Server server) {
        JasperListener jasperListener = new JasperListener();
        server.addLifecycleListener(jasperListener);
        jasperListener.lifecycleEvent(new LifecycleEvent(server, "before_init", null));
        server.addLifecycleListener(new JreMemoryLeakPreventionListener());
        server.addLifecycleListener(new ThreadLocalLeakPreventionListener());
    }

    private static void configureHost(Host host) {
        host.setAutoDeploy(false);
    }

    private Connector makeConnector() throws IOException {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        File keystoreFile = this.config.getKeystoreFile();
        String keystorePassword = this.config.getKeystorePassword();
        if (keystoreFile == null && keystorePassword == null) {
            connector.setPort(this.config.getPort());
            connector.setSecure(false);
            connector.setScheme("http");
        } else {
            if (keystoreFile == null || !keystoreFile.exists()) {
                log.info("Keystore file not found; trying to load remote keystore file if applicable");
                ResourceRetriever resourceRetriever = ClassUtils.loadInstanceOf("net.myrrix.online.io.DelegateResourceRetriever", ResourceRetriever.class);
                resourceRetriever.init(this.config.getBucket());
                keystoreFile = resourceRetriever.getKeystoreFile(this.config.getInstanceID());
                if (keystoreFile == null) {
                    throw new FileNotFoundException();
                }
            }
            connector.setPort(this.config.getSecurePort());
            connector.setSecure(true);
            connector.setScheme("https");
            connector.setAttribute("SSLEnabled", "true");
            String protocol = Runner.chooseSSLProtocol("TLSv1.1", "TLSv1");
            if (protocol != null) {
                connector.setAttribute("sslProtocol", protocol);
            }
            connector.setAttribute("keystoreFile", keystoreFile.getAbsoluteFile());
            connector.setAttribute("keystorePass", keystorePassword);
        }
        connector.setXpoweredBy(false);
        connector.setAttribute("server", "Myrrix");
        connector.setAttribute("maxThreads", 400);
        connector.setAttribute("acceptCount", 50);
        connector.setAttribute("maxKeepAliveRequests", 100);
        connector.setAttribute("socket.soReuseAddress", true);
        connector.setMaxPostSize(0);
        connector.setAttribute("disableUploadTimeout", false);
        return connector;
    }

    private static String chooseSSLProtocol(String ... protocols) {
        for (String protocol : protocols) {
            try {
                SSLContext.getInstance(protocol);
                return protocol;
            }
            catch (NoSuchAlgorithmException ignored) {
            }
        }
        return null;
    }

    private Context makeContext(Tomcat tomcat, File noSuchBaseDir, int port) throws IOException {
        boolean needAuthentication;
        File contextPath = new File(noSuchBaseDir, "context");
        if (!contextPath.mkdirs()) {
            throw new IOException("Could not create " + contextPath);
        }
        String contextPathURIBase = this.config.getContextPath();
        Context context = tomcat.addContext(contextPathURIBase == null ? "" : contextPathURIBase, contextPath.getAbsolutePath());
        context.addApplicationListener(new ApplicationListener(InitListener.class.getName(), false));
        context.setWebappVersion("3.0");
        context.addWelcomeFile("index.jspx");
        Runner.addErrorPages(context);
        ServletContext servletContext = context.getServletContext();
        servletContext.setAttribute(InitListener.INSTANCE_ID_KEY, this.config.getInstanceID());
        servletContext.setAttribute(InitListener.BUCKET_KEY, this.config.getBucket());
        servletContext.setAttribute(InitListener.RESCORER_PROVIDER_CLASS_KEY, this.config.getRescorerProviderClassName());
        servletContext.setAttribute(InitListener.CLIENT_THREAD_CLASS_KEY, this.config.getClientThreadClassName());
        servletContext.setAttribute(InitListener.LOCAL_INPUT_DIR_KEY, this.config.getLocalInputDir());
        servletContext.setAttribute(InitListener.PORT_KEY, port);
        servletContext.setAttribute(InitListener.READ_ONLY_KEY, this.config.isReadOnly());
        servletContext.setAttribute(InitListener.ALL_PARTITIONS_SPEC_KEY, this.config.getAllPartitionsSpecification());
        servletContext.setAttribute(InitListener.PARTITION_KEY, this.config.getPartition());
        boolean needHTTPS = this.config.getKeystoreFile() != null;
        boolean bl = needAuthentication = this.config.getUserName() != null;
        if (needHTTPS || needAuthentication) {
            SecurityCollection securityCollection = new SecurityCollection("Protected Resources");
            if (this.config.isConsoleOnlyPassword()) {
                securityCollection.addPattern("/index.jspx");
            } else {
                securityCollection.addPattern("/*");
            }
            SecurityConstraint securityConstraint = new SecurityConstraint();
            securityConstraint.addCollection(securityCollection);
            if (needHTTPS) {
                securityConstraint.setUserConstraint("CONFIDENTIAL");
            }
            if (needAuthentication) {
                LoginConfig loginConfig = new LoginConfig();
                loginConfig.setAuthMethod("DIGEST");
                loginConfig.setRealmName("Myrrix");
                context.setLoginConfig(loginConfig);
                securityConstraint.addAuthRole("myrrix-user");
                context.addSecurityRole("myrrix-user");
                DigestAuthenticator authenticator = new DigestAuthenticator();
                authenticator.setNonceValidity(10000L);
                authenticator.setNonceCacheSize(20000);
                context.getPipeline().addValve(authenticator);
            }
            context.addConstraint(securityConstraint);
        }
        context.setCookies(false);
        return context;
    }

    private static void addFilter(Context context, Filter filter, String path, Map<String, String> args) {
        String name = filter.getClass().getSimpleName();
        FilterDef dosFilterDef = new FilterDef();
        dosFilterDef.setFilter(filter);
        dosFilterDef.setFilterName(name);
        for (Map.Entry<String, String> entry : args.entrySet()) {
            dosFilterDef.addInitParameter(entry.getKey(), entry.getValue());
        }
        context.addFilterDef(dosFilterDef);
        FilterMap dosFilterMap = new FilterMap();
        dosFilterMap.setFilterName(name);
        dosFilterMap.addURLPattern(path);
        context.addFilterMap(dosFilterMap);
    }

    private static Wrapper addServlet(Context context, Servlet servlet, String path) {
        String name = servlet.getClass().getSimpleName();
        Wrapper servletWrapper = Tomcat.addServlet(context, name, servlet);
        servletWrapper.setLoadOnStartup(1);
        context.addServletMapping(path, name);
        return servletWrapper;
    }

    private static void addErrorPages(Context context) {
        for (int errorCode : ERROR_PAGE_STATUSES) {
            ErrorPage errorPage = new ErrorPage();
            errorPage.setErrorCode(errorCode);
            errorPage.setLocation("/error.jspx");
            context.addErrorPage(errorPage);
        }
        ErrorPage errorPage = new ErrorPage();
        errorPage.setExceptionType(Throwable.class.getName());
        errorPage.setLocation("/error.jspx");
        context.addErrorPage(errorPage);
    }
}

