/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.PlusAnonymousUserDataModel;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;

public final class PlusAnonymousConcurrentUserDataModel
extends PlusAnonymousUserDataModel {
    private final Map<Long, PreferenceArray> tempPrefs = new ConcurrentHashMap<Long, PreferenceArray>();
    private final Map<Long, FastIDSet> prefItemIDs = new ConcurrentHashMap<Long, FastIDSet>();
    private Queue<Long> usersPool;

    public PlusAnonymousConcurrentUserDataModel(DataModel delegate, int maxConcurrentUsers) {
        super(delegate);
        this.initializeUsersPools(maxConcurrentUsers);
    }

    private void initializeUsersPools(int usersPoolSize) {
        this.usersPool = new ConcurrentLinkedQueue<Long>();
        for (int i = 0; i < usersPoolSize; ++i) {
            this.usersPool.add(Long.MIN_VALUE + (long)i);
        }
    }

    public Long takeAvailableUser() {
        Long takenUserID = this.usersPool.poll();
        if (takenUserID != null) {
            this.tempPrefs.put(takenUserID, new GenericUserPreferenceArray(0));
            return takenUserID;
        }
        return null;
    }

    public boolean releaseUser(Long userID) {
        if (this.tempPrefs.containsKey(userID)) {
            this.clearTempPrefs(userID);
            this.usersPool.offer(userID);
            return true;
        }
        return false;
    }

    private boolean isAnonymousUser(long userID) {
        return this.tempPrefs.containsKey(userID);
    }

    public void setTempPrefs(PreferenceArray prefs, long anonymousUserID) {
        Preconditions.checkArgument(prefs != null && prefs.length() > 0, "prefs is null or empty");
        this.tempPrefs.put(anonymousUserID, prefs);
        FastIDSet userPrefItemIDs = new FastIDSet();
        for (int i = 0; i < prefs.length(); ++i) {
            userPrefItemIDs.add(prefs.getItemID(i));
        }
        this.prefItemIDs.put(anonymousUserID, userPrefItemIDs);
    }

    public void clearTempPrefs(long anonymousUserID) {
        this.tempPrefs.remove(anonymousUserID);
        this.prefItemIDs.remove(anonymousUserID);
    }

    @Override
    public LongPrimitiveIterator getUserIDs() throws TasteException {
        return this.getDelegate().getUserIDs();
    }

    @Override
    public PreferenceArray getPreferencesFromUser(long userID) throws TasteException {
        if (this.isAnonymousUser(userID)) {
            return this.tempPrefs.get(userID);
        }
        return this.getDelegate().getPreferencesFromUser(userID);
    }

    @Override
    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        if (this.isAnonymousUser(userID)) {
            return this.prefItemIDs.get(userID);
        }
        return this.getDelegate().getItemIDsFromUser(userID);
    }

    @Override
    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        if (this.tempPrefs.isEmpty()) {
            return this.getDelegate().getPreferencesForItem(itemID);
        }
        PreferenceArray delegatePrefs = null;
        try {
            delegatePrefs = this.getDelegate().getPreferencesForItem(itemID);
        }
        catch (NoSuchItemException nsie) {
            // empty catch block
        }
        ArrayList<Preference> anonymousPreferences = new ArrayList<Preference>();
        for (Map.Entry<Long, PreferenceArray> prefsMap : this.tempPrefs.entrySet()) {
            PreferenceArray singleUserTempPrefs = prefsMap.getValue();
            for (int i = 0; i < singleUserTempPrefs.length(); ++i) {
                if (singleUserTempPrefs.getItemID(i) != itemID) continue;
                anonymousPreferences.add(singleUserTempPrefs.get(i));
            }
        }
        int delegateLength = delegatePrefs == null ? 0 : delegatePrefs.length();
        int anonymousPrefsLength = anonymousPreferences.size();
        int prefsCounter = 0;
        GenericItemPreferenceArray newPreferenceArray = new GenericItemPreferenceArray(delegateLength + anonymousPrefsLength);
        for (int i = 0; i < delegateLength; ++i) {
            newPreferenceArray.set(prefsCounter++, delegatePrefs.get(i));
        }
        for (Preference anonymousPreference : anonymousPreferences) {
            newPreferenceArray.set(prefsCounter++, anonymousPreference);
        }
        if (newPreferenceArray.length() == 0) {
            throw new NoSuchItemException(itemID);
        }
        return newPreferenceArray;
    }

    @Override
    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        if (this.isAnonymousUser(userID)) {
            PreferenceArray singleUserTempPrefs = this.tempPrefs.get(userID);
            for (int i = 0; i < singleUserTempPrefs.length(); ++i) {
                if (singleUserTempPrefs.getItemID(i) != itemID) continue;
                return Float.valueOf(singleUserTempPrefs.getValue(i));
            }
            return null;
        }
        return this.getDelegate().getPreferenceValue(userID, itemID);
    }

    @Override
    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        if (this.isAnonymousUser(userID)) {
            return null;
        }
        return this.getDelegate().getPreferenceTime(userID, itemID);
    }

    @Override
    public int getNumUsers() throws TasteException {
        return this.getDelegate().getNumUsers();
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        if (this.tempPrefs.isEmpty()) {
            return this.getDelegate().getNumUsersWithPreferenceFor(itemID);
        }
        int countAnonymousUsersWithPreferenceFor = 0;
        block0: for (Map.Entry<Long, PreferenceArray> singleUserTempPrefs : this.tempPrefs.entrySet()) {
            for (int i = 0; i < singleUserTempPrefs.getValue().length(); ++i) {
                if (singleUserTempPrefs.getValue().getItemID(i) != itemID) continue;
                ++countAnonymousUsersWithPreferenceFor;
                continue block0;
            }
        }
        return this.getDelegate().getNumUsersWithPreferenceFor(itemID) + countAnonymousUsersWithPreferenceFor;
    }

    @Override
    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        if (this.tempPrefs.isEmpty()) {
            return this.getDelegate().getNumUsersWithPreferenceFor(itemID1, itemID2);
        }
        int countAnonymousUsersWithPreferenceFor = 0;
        for (Map.Entry<Long, PreferenceArray> singleUserTempPrefs : this.tempPrefs.entrySet()) {
            boolean found1 = false;
            boolean found2 = false;
            for (int i = 0; !(i >= singleUserTempPrefs.getValue().length() || found1 && found2); ++i) {
                long itemID = singleUserTempPrefs.getValue().getItemID(i);
                if (itemID == itemID1) {
                    found1 = true;
                }
                if (itemID != itemID2) continue;
                found2 = true;
            }
            if (!found1 || !found2) continue;
            ++countAnonymousUsersWithPreferenceFor;
        }
        return this.getDelegate().getNumUsersWithPreferenceFor(itemID1, itemID2) + countAnonymousUsersWithPreferenceFor;
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        if (this.isAnonymousUser(userID)) {
            throw new UnsupportedOperationException();
        }
        this.getDelegate().setPreference(userID, itemID, value);
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        if (this.isAnonymousUser(userID)) {
            throw new UnsupportedOperationException();
        }
        this.getDelegate().removePreference(userID, itemID);
    }
}

