/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.neighborhood;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

abstract class AbstractUserNeighborhood
implements UserNeighborhood {
    private final UserSimilarity userSimilarity;
    private final DataModel dataModel;
    private final double samplingRate;
    private final RefreshHelper refreshHelper;

    AbstractUserNeighborhood(UserSimilarity userSimilarity, DataModel dataModel, double samplingRate) {
        Preconditions.checkArgument(userSimilarity != null, "userSimilarity is null");
        Preconditions.checkArgument(dataModel != null, "dataModel is null");
        Preconditions.checkArgument(samplingRate > 0.0 && samplingRate <= 1.0, "samplingRate must be in (0,1]");
        this.userSimilarity = userSimilarity;
        this.dataModel = dataModel;
        this.samplingRate = samplingRate;
        this.refreshHelper = new RefreshHelper(null);
        this.refreshHelper.addDependency(this.dataModel);
        this.refreshHelper.addDependency(this.userSimilarity);
    }

    final UserSimilarity getUserSimilarity() {
        return this.userSimilarity;
    }

    final DataModel getDataModel() {
        return this.dataModel;
    }

    final double getSamplingRate() {
        return this.samplingRate;
    }

    @Override
    public final void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }
}

