### R code from vignette source 'PBC.Rnw'

###################################################
### code chunk number 1: PBC.Rnw:25-26
###################################################
library(PBC)


###################################################
### code chunk number 2: PBC.Rnw:29-30
###################################################
g <- graph.formula(X1-X2, X2-X3, X3-X4, X4-X5, simplify = FALSE)


###################################################
### code chunk number 3: PBC.Rnw:33-34
###################################################
myPBC <- pbcGumbel(g)


###################################################
### code chunk number 4: PBC.Rnw:37-38
###################################################
myPBC <- pbc(g, model="gumbel") 


###################################################
### code chunk number 5: PBC.Rnw:43-44
###################################################
pbcPlot(myPBC)


###################################################
### code chunk number 6: PBC.Rnw:51-55
###################################################
theta <- 1:4
n <- 100
data <- rPBC(n, theta, myPBC)
head(data)


###################################################
### code chunk number 7: PBC.Rnw:58-60
###################################################
init <- 1/runif(4)
theta.hat <- pbcOptim(init, data, myPBC, method = 'BFGS')


###################################################
### code chunk number 8: PBC.Rnw:62-63
###################################################
print(theta.hat)


