### R code from vignette source 'PROFANCY.Rnw'

###################################################
### code chunk number 1: PROFANCY.Rnw:45-46
###################################################
library(PROFANCY)


###################################################
### code chunk number 2: PROFANCY.Rnw:53-57
###################################################
#get path of the KGML files
ProvidedDiseaseName<-getProvidedDiseaseName()
print(ProvidedDiseaseName[1:5])
length(ProvidedDiseaseName)


###################################################
### code chunk number 3: PROFANCY.Rnw:74-121
###################################################
##Example 1: Users have chose disease name provided by system and network
## is set "EHMN". The seeds and candidates are default.
ProvidedDiseaseName<-getProvidedDiseaseName() ##get all disease name provided.
diseaseName<-ProvidedDiseaseName[17]  ##choose the disease you want to study.
example1<-getTopDiseaseMetabolites(diseaseName=diseaseName,network="EHMN"
          ,seedDefault=TRUE,showTop=30,candidateDefault=TRUE)
print(example1[1:5,])
#write.table(example1,"example1.txt",quote=FALSE,row.names=FALSE,sep="\t")


##Example 2: The disease name is provided by users. The seeds and candidates
## are provided by users. The network is set "KEGG".
diseaseName<-"prostate cancer"  ##the disease name provided by users.
path1<-paste(system.file(package="PROFANCY"),"/localdata/ProstateCandidates.txt",sep="")
candidateExample<-read.table(path1)
candidateExample<-candidateExample[[1]]
path2<-paste(system.file(package="PROFANCY"),"/localdata/ProstateSeeds.txt",sep="")
seedExample<-read.table(path2)
seedExample<-seedExample[[1]]
example2<-getTopDiseaseMetabolites(diseaseName,network="KEGG",seed=seedExample,
      candidates=candidateExample,seedDefault=FALSE,showTop=30,candidateDefault=FALSE)
print(example2[1:5,])
#write.table(example2,"example2.txt",quote=FALSE,row.names=FALSE,sep="\t")



##Example 3: Disease name chose in our provided. The seeds are provided by default.
## The candidates are provided by users. Network is set "EHMN".
path1<-paste(system.file(package="PROFANCY"),"/localdata/ProstateCandidates.txt",sep="")
candidateExample<-read.table(path1)
candidateExample<-candidateExample[[1]]
example3<-getTopDiseaseMetabolites(diseaseName="Prostate cancer",network="EHMN",
          candidates=candidateExample,seedDefault=TRUE,showTop=30,candidateDefault=FALSE)
print(example3[1:5,])
#write.table(example3,"example3.txt",quote=FALSE,row.names=FALSE,sep="\t")



##Example 4: Disease name chose in our provided. The seeds are provided by users. 
##The candidates are provided by default. Network is set "KEGG".
path2<-paste(system.file(package="PROFANCY"),"/localdata/ProstateSeeds.txt",sep="")
seedExample<-read.table(path2)
seedExample<-seedExample[[1]]
example4<-getTopDiseaseMetabolites(diseaseName="Prostate cancer",network="KEGG",
                 seed=seedExample,seedDefault=FALSE,showTop=30,candidateDefault=TRUE)
print(example4[1:5,])
#write.table(example4,"example4.txt",quote=FALSE,row.names=FALSE,sep="\t")


###################################################
### code chunk number 4: PROFANCY.Rnw:128-144
###################################################
#############    Get disease seed metabolites   ################
##Example 1: Users have chose disease name provided by system (Prostate cancer), 
##network is set "EHMN". The seeds are provided by default.
seed1<-getSeed(diseaseName="Prostate cancer",network="EHMN",seedDefault=TRUE)
print(seed1[1:5])



##Example 2: The disease name is provided by users. The seeds are provided by users. 
##The network is set "KEGG".
diseaseName<-"prostate cancer"  ##the disease name provided by users.
path2<-paste(system.file(package="PROFANCY"),"/localdata/ProstateSeeds.txt",sep="")
seedExample<-read.table(path2)
seedExample<-seedExample[[1]]
seed2<-getSeed(diseaseName="Prostate cancer",network="EHMN",seed=seedExample,seedDefault=FALSE)
print(seed2[1:5])


###################################################
### code chunk number 5: PROFANCY.Rnw:151-172
###################################################
#############    Get disease candidates   ################
##Example 1: Users have chose disease name provided by system (Prostate cancer),
## network is set to "EHMN". 
##The candidates and seed metabolites are default.
Candidates1<-getCandidates(diseaseName="Prostate cancer",network="EHMN",
                 seedDefault=TRUE,candidateDefault=TRUE)
print(Candidates1[1:5])



##Example 2: The disease name is input by users. The seeds are provided by users.
##The network is set to "KEGG".The candidates are provided by users.
path1<-paste(system.file(package="PROFANCY"),"/localdata/ProstateCandidates.txt",sep="")
candidateExample<-read.table(path1)
candidateExample<-candidateExample[[1]]
path2<-paste(system.file(package="PROFANCY"),"/localdata/ProstateSeeds.txt",sep="")
seedExample<-read.table(path2)
seedExample<-seedExample[[1]]
Candidates2<-getCandidates(diseaseName="Prostate cancer",network="KEGG",seed=seedExample,
            seedDefault=FALSE,candidates=candidateExample,candidateDefault=FALSE)
print(Candidates2[1:5])


###################################################
### code chunk number 6: PROFANCY.Rnw:180-182
###################################################
##data in environment variable envData
ls(envData)


###################################################
### code chunk number 7: PROFANCY.Rnw:186-188
###################################################
#get information of all metabolites in the network
MetaboliteInf<-get("MetaboliteInf",envir=envData)


