/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NearestNeighbourSearch;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class LinearNN
extends NearestNeighbourSearch
implements OptionHandler {
    static final long serialVersionUID = -7318654963683219025L;
    private double[] m_Distances;
    private boolean m_SkipIdentical = false;

    public LinearNN() {
    }

    public LinearNN(Instances instances) {
        super(instances);
        this.m_DistanceFunction.setInstances(instances);
    }

    public String globalInfo() {
        return "Class implementing the brute force search algorithm for nearest neighbour search.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tSkip identical instances (distances equal to zero).\n", "S", 1, "-S"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        this.setSkipIdentical(Utils.getFlag('S', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getSkipIdentical()) {
            vector.add("-S");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Instance nearestNeighbour(Instance instance) throws Exception {
        return this.kNearestNeighbours(instance, 1).instance(0);
    }

    public Instances kNearestNeighbours(Instance instance, int n) throws Exception {
        MyHeapElement myHeapElement;
        Object object;
        boolean bl = false;
        MyHeap myHeap = new MyHeap(n);
        int n2 = 0;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            double d;
            if (instance == this.m_Instances.instance(i)) continue;
            if (n2 < n) {
                if (bl) {
                    System.out.println("K: " + (myHeap.size() + myHeap.noOfKthNearest()));
                }
                d = ((EuclideanDistance)this.m_DistanceFunction).distance(instance, this.m_Instances.instance(i), Double.MAX_VALUE, bl);
                if (this.m_SkipIdentical && d == 0.0) {
                    if (i < this.m_Instances.numInstances() - 1) continue;
                    myHeap.put(i, d);
                }
                myHeap.put(i, d);
                ++n2;
                continue;
            }
            object = myHeap.peek();
            if (bl) {
                System.out.println("K: " + (myHeap.size() + myHeap.noOfKthNearest()));
            }
            d = ((EuclideanDistance)this.m_DistanceFunction).distance(instance, this.m_Instances.instance(i), ((MyHeapElement)object).distance, bl);
            if (this.m_SkipIdentical && d == 0.0) continue;
            if (d < ((MyHeapElement)object).distance) {
                myHeap.putBySubstitute(i, d);
                continue;
            }
            if (d != ((MyHeapElement)object).distance) continue;
            myHeap.putKthNearest(i, d);
        }
        Instances instances = new Instances(this.m_Instances, myHeap.size() + myHeap.noOfKthNearest());
        this.m_Distances = new double[myHeap.size() + myHeap.noOfKthNearest()];
        object = new int[myHeap.size() + myHeap.noOfKthNearest()];
        int n3 = 1;
        while (myHeap.noOfKthNearest() > 0) {
            myHeapElement = myHeap.getKthNearest();
            object[((Object)object).length - n3] = myHeapElement.index;
            this.m_Distances[((Object)object).length - n3] = myHeapElement.distance;
            ++n3;
        }
        while (myHeap.size() > 0) {
            myHeapElement = myHeap.get();
            object[((Object)object).length - n3] = myHeapElement.index;
            this.m_Distances[((Object)object).length - n3] = myHeapElement.distance;
            ++n3;
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        for (int i = 0; i < ((Object)object).length; ++i) {
            instances.add(this.m_Instances.instance((int)object[i]));
        }
        return instances;
    }

    public double[] getDistances() throws Exception {
        if (this.m_Distances == null) {
            throw new Exception("No distances available. Please call either kNearestNeighbours or nearestNeighbours first.");
        }
        return this.m_Distances;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_DistanceFunction.setInstances(instances);
    }

    public void update(Instance instance) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
        this.m_DistanceFunction.update(instance);
    }

    public void addInstanceInfo(Instance instance) {
        if (this.m_Instances != null) {
            try {
                this.update(instance);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String skipIdenticalTipText() {
        return "Whether to skip identical instances (with distance 0 to the target)";
    }

    public void setSkipIdentical(boolean bl) {
        this.m_SkipIdentical = bl;
    }

    public boolean getSkipIdentical() {
        return this.m_SkipIdentical;
    }

    private class MyHeapElement {
        int index;
        double distance;

        public MyHeapElement(int n, double d) {
            this.distance = d;
            this.index = n;
        }
    }

    private class MyHeap {
        MyHeapElement[] m_heap = null;
        MyHeapElement[] m_KthNearest = null;
        int m_KthNearestSize = 0;
        int initSize = 10;

        public MyHeap(int n) {
            if (n % 2 == 0) {
                ++n;
            }
            this.m_heap = new MyHeapElement[n + 1];
            this.m_heap[0] = new MyHeapElement(0, 0.0);
        }

        public int size() {
            return this.m_heap[0].index;
        }

        public MyHeapElement peek() {
            return this.m_heap[1];
        }

        public MyHeapElement get() throws Exception {
            if (this.m_heap[0].index == 0) {
                throw new Exception("No elements present in the heap");
            }
            MyHeapElement myHeapElement = this.m_heap[1];
            this.m_heap[1] = this.m_heap[this.m_heap[0].index];
            --this.m_heap[0].index;
            this.downheap();
            return myHeapElement;
        }

        public void put(int n, double d) throws Exception {
            if (this.m_heap[0].index + 1 > this.m_heap.length - 1) {
                throw new Exception("the number of elements cannot exceed the initially set maximum limit");
            }
            ++this.m_heap[0].index;
            this.m_heap[this.m_heap[0].index] = new MyHeapElement(n, d);
            this.upheap();
        }

        public void putBySubstitute(int n, double d) throws Exception {
            MyHeapElement myHeapElement = this.get();
            this.put(n, d);
            if (myHeapElement.distance == this.m_heap[1].distance) {
                this.putKthNearest(myHeapElement.index, myHeapElement.distance);
            } else if (myHeapElement.distance > this.m_heap[1].distance) {
                this.m_KthNearest = null;
                this.m_KthNearestSize = 0;
                this.initSize = 10;
            } else if (myHeapElement.distance < this.m_heap[1].distance) {
                throw new Exception("The substituted element is smaller than the head element. put() should have been called in place of putBySubstitute()");
            }
        }

        public int noOfKthNearest() {
            return this.m_KthNearestSize;
        }

        public void putKthNearest(int n, double d) {
            if (this.m_KthNearest == null) {
                this.m_KthNearest = new MyHeapElement[this.initSize];
            }
            if (this.m_KthNearestSize >= this.m_KthNearest.length) {
                this.initSize += this.initSize;
                MyHeapElement[] myHeapElementArray = new MyHeapElement[this.initSize];
                System.arraycopy(this.m_KthNearest, 0, myHeapElementArray, 0, this.m_KthNearest.length);
                this.m_KthNearest = myHeapElementArray;
            }
            this.m_KthNearest[this.m_KthNearestSize++] = new MyHeapElement(n, d);
        }

        public MyHeapElement getKthNearest() {
            if (this.m_KthNearestSize == 0) {
                return null;
            }
            --this.m_KthNearestSize;
            return this.m_KthNearest[this.m_KthNearestSize];
        }

        private void upheap() {
            int n = this.m_heap[0].index;
            while (n > 1 && this.m_heap[n].distance > this.m_heap[n / 2].distance) {
                MyHeapElement myHeapElement = this.m_heap[n];
                this.m_heap[n] = this.m_heap[n / 2];
                this.m_heap[n /= 2] = myHeapElement;
            }
        }

        private void downheap() {
            int n = 1;
            while (2 * n <= this.m_heap[0].index && this.m_heap[n].distance < this.m_heap[2 * n].distance || 2 * n + 1 <= this.m_heap[0].index && this.m_heap[n].distance < this.m_heap[2 * n + 1].distance) {
                MyHeapElement myHeapElement;
                if (2 * n + 1 <= this.m_heap[0].index) {
                    if (this.m_heap[2 * n].distance > this.m_heap[2 * n + 1].distance) {
                        myHeapElement = this.m_heap[n];
                        this.m_heap[n] = this.m_heap[2 * n];
                        n = 2 * n;
                        this.m_heap[n] = myHeapElement;
                        continue;
                    }
                    myHeapElement = this.m_heap[n];
                    this.m_heap[n] = this.m_heap[2 * n + 1];
                    n = 2 * n + 1;
                    this.m_heap[n] = myHeapElement;
                    continue;
                }
                myHeapElement = this.m_heap[n];
                this.m_heap[n] = this.m_heap[2 * n];
                n = 2 * n;
                this.m_heap[n] = myHeapElement;
            }
        }
    }
}

