/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage.common;

import java.util.regex.Pattern;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.SemanticException;

public class Operators {
    public static Node plus(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Addition((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        if (left instanceof Primitives.StringExpression && right instanceof Primitives.StringExpression) {
            return new Concatenation((Primitives.StringExpression)left, (Primitives.StringExpression)right);
        }
        throw new SemanticException("Plus is only applicable to doubles & Strings!");
    }

    public static Node minus(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Subtraction((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("Minus is only applicable to doubles!");
    }

    public static Node times(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Multiplication((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("Multiplication is only applicable to doubles!");
    }

    public static Node division(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Division((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("division is only applicable to doubles!");
    }

    public static Node uplus(Node expr) throws SemanticException {
        if (expr instanceof Primitives.DoubleExpression) {
            return expr;
        }
        throw new SemanticException("unary minus is only applicable to doubles!");
    }

    public static Node uminus(Node expr) throws SemanticException {
        if (expr instanceof Primitives.DoubleExpression) {
            return new UMinus((Primitives.DoubleExpression)expr);
        }
        throw new SemanticException("unary minus is only applicable to doubles!");
    }

    public static Node pow(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Pow((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("Power is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression lessThan(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new LessThan((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("less than is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression lessEqual(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new LessEqual((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("less equal is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression greaterThan(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new GreaterThan((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("greater than is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression greaterEqual(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new GreaterEqual((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("greater equal is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression equal(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.DoubleExpression && right instanceof Primitives.DoubleExpression) {
            return new Equal((Primitives.DoubleExpression)left, (Primitives.DoubleExpression)right);
        }
        throw new SemanticException("equal is only applicable to doubles!");
    }

    public static Primitives.BooleanExpression not(Node expr) throws SemanticException {
        if (expr instanceof Primitives.BooleanExpression) {
            return new Not((Primitives.BooleanExpression)expr);
        }
        throw new SemanticException("Logical not is only applicable to booleans!");
    }

    public static Primitives.BooleanExpression and(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.BooleanExpression && right instanceof Primitives.BooleanExpression) {
            return new And((Primitives.BooleanExpression)left, (Primitives.BooleanExpression)right);
        }
        throw new SemanticException("Logical and is only applicable to booleans!");
    }

    public static Primitives.BooleanExpression or(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.BooleanExpression && right instanceof Primitives.BooleanExpression) {
            return new Or((Primitives.BooleanExpression)left, (Primitives.BooleanExpression)right);
        }
        throw new SemanticException("Logical or is only applicable to booleans!");
    }

    public static Primitives.BooleanExpression is(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.StringExpression && right instanceof Primitives.StringExpression) {
            return new Is((Primitives.StringExpression)left, (Primitives.StringExpression)right);
        }
        throw new SemanticException("Is operator is only applicable to strings!");
    }

    public static Primitives.BooleanExpression regexp(Node left, Node right) throws SemanticException {
        if (left instanceof Primitives.StringExpression) {
            if (right instanceof Primitives.StringConstant) {
                return new CompiledRegexp((Primitives.StringExpression)left, ((Primitives.StringConstant)right).evaluate());
            }
            if (right instanceof Primitives.StringExpression) {
                return new Regexp((Primitives.StringExpression)left, (Primitives.StringExpression)right);
            }
        }
        throw new SemanticException("Is operator is only applicable to strings!");
    }

    private static class Concatenation
    implements Primitives.StringExpression {
        private final Primitives.StringExpression left;
        private final Primitives.StringExpression right;

        public Concatenation(Primitives.StringExpression left, Primitives.StringExpression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public String evaluate() {
            return this.left.evaluate() + this.right.evaluate();
        }
    }

    private static class CompiledRegexp
    implements Primitives.BooleanExpression {
        private final Primitives.StringExpression expr;
        private final Pattern pattern;

        public CompiledRegexp(Primitives.StringExpression expr, String pattern) {
            this.expr = expr;
            this.pattern = Pattern.compile(pattern);
        }

        @Override
        public boolean evaluate() {
            return this.pattern.matcher(this.expr.evaluate()).matches();
        }
    }

    private static class Regexp
    extends BooleanBinaryExpression<Primitives.StringExpression> {
        public Regexp(Primitives.StringExpression left, Primitives.StringExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.StringExpression)this.left).evaluate().matches(((Primitives.StringExpression)this.right).evaluate());
        }
    }

    private static class Is
    extends BooleanBinaryExpression<Primitives.StringExpression> {
        public Is(Primitives.StringExpression left, Primitives.StringExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.StringExpression)this.left).evaluate().equals(((Primitives.StringExpression)this.right).evaluate());
        }
    }

    private static class Not
    implements Primitives.BooleanExpression {
        private final Primitives.BooleanExpression expr;

        public Not(Primitives.BooleanExpression expr) {
            this.expr = expr;
        }

        @Override
        public boolean evaluate() {
            return !this.expr.evaluate();
        }
    }

    private static class Or
    extends BooleanBinaryExpression<Primitives.BooleanExpression> {
        public Or(Primitives.BooleanExpression left, Primitives.BooleanExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.BooleanExpression)this.left).evaluate() || ((Primitives.BooleanExpression)this.right).evaluate();
        }
    }

    private static class And
    extends BooleanBinaryExpression<Primitives.BooleanExpression> {
        public And(Primitives.BooleanExpression left, Primitives.BooleanExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.BooleanExpression)this.left).evaluate() && ((Primitives.BooleanExpression)this.right).evaluate();
        }
    }

    private static class Equal
    extends BooleanBinaryExpression<Primitives.DoubleExpression> {
        public Equal(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() == ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class GreaterEqual
    extends BooleanBinaryExpression<Primitives.DoubleExpression> {
        public GreaterEqual(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() >= ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class GreaterThan
    extends BooleanBinaryExpression<Primitives.DoubleExpression> {
        public GreaterThan(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() > ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class LessEqual
    extends BooleanBinaryExpression<Primitives.DoubleExpression> {
        public LessEqual(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() <= ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static class LessThan
    extends BooleanBinaryExpression<Primitives.DoubleExpression> {
        public LessThan(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public boolean evaluate() {
            return ((Primitives.DoubleExpression)this.left).evaluate() < ((Primitives.DoubleExpression)this.right).evaluate();
        }
    }

    private static abstract class BooleanBinaryExpression<T>
    implements Primitives.BooleanExpression {
        final T left;
        final T right;

        public BooleanBinaryExpression(T left, T right) {
            this.left = left;
            this.right = right;
        }
    }

    private static class Pow
    extends DoubleBinaryExpression {
        public Pow(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return Math.pow(this.left.evaluate(), this.right.evaluate());
        }
    }

    private static class Division
    extends DoubleBinaryExpression {
        public Division(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return this.left.evaluate() / this.right.evaluate();
        }
    }

    private static class UMinus
    implements Primitives.DoubleExpression {
        private final Primitives.DoubleExpression expr;

        public UMinus(Primitives.DoubleExpression expr) {
            this.expr = expr;
        }

        @Override
        public double evaluate() {
            return -this.expr.evaluate();
        }
    }

    private static class Multiplication
    extends DoubleBinaryExpression {
        public Multiplication(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return this.left.evaluate() * this.right.evaluate();
        }
    }

    private static class Subtraction
    extends DoubleBinaryExpression {
        public Subtraction(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return this.left.evaluate() - this.right.evaluate();
        }
    }

    private static class Addition
    extends DoubleBinaryExpression {
        public Addition(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            super(left, right);
        }

        @Override
        public double evaluate() {
            return this.left.evaluate() + this.right.evaluate();
        }
    }

    private static abstract class DoubleBinaryExpression
    implements Primitives.DoubleExpression {
        final Primitives.DoubleExpression left;
        final Primitives.DoubleExpression right;

        public DoubleBinaryExpression(Primitives.DoubleExpression left, Primitives.DoubleExpression right) {
            this.left = left;
            this.right = right;
        }
    }
}

