/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.expressionlanguage.common.IfElseMacro;
import weka.core.expressionlanguage.common.JavaMacro;
import weka.core.expressionlanguage.common.MacroDeclarationsCompositor;
import weka.core.expressionlanguage.common.MathFunctions;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.parser.Parser;
import weka.core.expressionlanguage.weka.InstancesHelper;
import weka.filters.SimpleBatchFilter;

public class SubsetByExpression
extends SimpleBatchFilter {
    private static final long serialVersionUID = 5628686110979589602L;
    protected String m_Expression = "true";
    protected boolean m_filterAfterFirstBatch = false;

    @Override
    public String globalInfo() {
        return "Filters instances according to a user-specified expression.\n\n\nExamples:\n- extracting only mammals and birds from the 'zoo' UCI dataset:\n  (CLASS is 'mammal') or (CLASS is 'bird')\n- extracting only animals with at least 2 legs from the 'zoo' UCI dataset:\n  (ATT14 >= 2)\n- extracting only instances with non-missing 'wage-increase-second-year'\n  from the 'labor' UCI dataset:\n  not ismissing(ATT3)\n";
    }

    @Override
    public boolean mayRemoveInstanceAfterFirstBatchDone() {
        return true;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.bufferInput(instance);
        int numReturnedFromParser = 0;
        if (this.isFirstBatchDone()) {
            Instances inst = new Instances(this.getInputFormat());
            inst = this.process(inst);
            numReturnedFromParser = inst.numInstances();
            for (int i = 0; i < inst.numInstances(); ++i) {
                this.push(inst.instance(i));
            }
            this.flushInput();
        }
        return numReturnedFromParser > 0;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe expression to use for filtering\n\t(default: true).", "E", 1, "-E <expr>"));
        result.addElement(new Option("\tApply the filter to instances that arrive after the first\n\t(training) batch. The default is to not apply the filter (i.e.\n\talways return the instance)", "F", 0, "-F"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('E', options);
        if (tmpStr.length() != 0) {
            this.setExpression(tmpStr);
        } else {
            this.setExpression("true");
        }
        this.m_filterAfterFirstBatch = Utils.getFlag('F', options);
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-E");
        result.add("" + this.getExpression());
        if (this.m_filterAfterFirstBatch) {
            result.add("-F");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void setExpression(String value) {
        this.m_Expression = value;
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to used for filtering the dataset.";
    }

    public void setFilterAfterFirstBatch(boolean b) {
        this.m_filterAfterFirstBatch = b;
    }

    public boolean getFilterAfterFirstBatch() {
        return this.m_filterAfterFirstBatch;
    }

    public String filterAfterFirstBatchTipText() {
        return "Whether to apply the filtering process to instances that are input after the first (training) batch. The default is false so that, when used in a FilteredClassifier, test instances do not potentially get 'consumed' by the filter an a prediction is always made.";
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone() || this.m_filterAfterFirstBatch) {
            Instances output = new Instances(instances, 0);
            InstancesHelper instancesHelper = new InstancesHelper(instances);
            Node node = Parser.parse(this.m_Expression, instancesHelper, new MacroDeclarationsCompositor(instancesHelper, new MathFunctions(), new IfElseMacro(), new JavaMacro()));
            if (!(node instanceof Primitives.BooleanExpression)) {
                throw new Exception("Expression must be of boolean type!");
            }
            Primitives.BooleanExpression condition = (Primitives.BooleanExpression)node;
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.get(i);
                instancesHelper.setInstance(instance);
                if (!condition.evaluate()) continue;
                output.add((Instance)instance.copy());
            }
            return output;
        }
        return instances;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11497 $");
    }

    public static void main(String[] args) {
        SubsetByExpression.runFilter(new SubsetByExpression(), args);
    }
}

