/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.streams;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.streams.InstanceEvent;
import weka.gui.streams.InstanceListener;
import weka.gui.streams.InstanceProducer;

public class InstanceCounter
extends JPanel
implements InstanceListener {
    private static final long serialVersionUID = -6084967152645935934L;
    private final JLabel m_Count_Lab = new JLabel("no instances");
    private int m_Count = 0;
    private boolean m_Debug;

    public void input(Instance instance) throws Exception {
        if (this.m_Debug) {
            System.err.println("InstanceCounter::input(" + instance + ")");
        }
        ++this.m_Count;
        this.m_Count_Lab.setText("" + this.m_Count + " instances");
        this.repaint();
    }

    public void inputFormat(Instances instanceInfo) {
        if (this.m_Debug) {
            System.err.println("InstanceCounter::inputFormat()");
        }
        this.m_Count = 0;
        this.m_Count_Lab.setText("" + this.m_Count + " instances");
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public InstanceCounter() {
        this.add(this.m_Count_Lab);
        this.setBackground(Color.lightGray);
    }

    @Override
    public void instanceProduced(InstanceEvent e) {
        Object source = e.getSource();
        if (source instanceof InstanceProducer) {
            try {
                InstanceProducer a = (InstanceProducer)source;
                switch (e.getID()) {
                    case 1: {
                        this.inputFormat(a.outputFormat());
                        break;
                    }
                    case 2: {
                        this.input(a.outputPeek());
                        break;
                    }
                    case 3: {
                        if (this.m_Debug) {
                            System.err.println("InstanceCounter::instanceProduced() - End of instance batch");
                        }
                        break;
                    }
                    default: {
                        System.err.println("InstanceCounter::instanceProduced() - unknown event type");
                        break;
                    }
                }
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            System.err.println("InstanceCounter::instanceProduced() - Unknown source object type");
        }
    }
}

