/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.datareaders.DataReader;
import org.apache.sanselan.formats.tiff.datareaders.DataReaderStrips;
import org.apache.sanselan.formats.tiff.datareaders.DataReaderTiled;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public abstract class TiffImageData {
    public abstract TiffElement.DataElement[] getImageData();

    public abstract boolean stripsNotTiles();

    public abstract DataReader getDataReader(ArrayList var1, PhotometricInterpreter var2, int var3, int[] var4, int var5, int var6, int var7, int var8, int var9) throws IOException, ImageReadException;

    public static class Data
    extends TiffElement.DataElement {
        public Data(int offset, int length, byte[] data) {
            super(offset, length, data);
        }

        public String getElementDescription(boolean verbose) {
            return "Tiff image data: " + this.data.length + " bytes";
        }
    }

    public static class Strips
    extends TiffImageData {
        public final TiffElement.DataElement[] strips;
        public final int rowsPerStrip;

        public Strips(TiffElement.DataElement[] strips, int rowsPerStrip) {
            this.strips = strips;
            this.rowsPerStrip = rowsPerStrip;
        }

        public TiffElement.DataElement[] getImageData() {
            return this.strips;
        }

        public boolean stripsNotTiles() {
            return true;
        }

        public DataReader getDataReader(ArrayList entries, PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression) throws IOException, ImageReadException {
            return new DataReaderStrips(photometricInterpreter, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression, this.rowsPerStrip, this);
        }
    }

    public static class Tiles
    extends TiffImageData {
        public final TiffElement.DataElement[] tiles;
        private final int tileWidth;
        private final int tileLength;

        public Tiles(TiffElement.DataElement[] tiles, int tileWidth, int tileLength) {
            this.tiles = tiles;
            this.tileWidth = tileWidth;
            this.tileLength = tileLength;
        }

        public TiffElement.DataElement[] getImageData() {
            return this.tiles;
        }

        public boolean stripsNotTiles() {
            return false;
        }

        public DataReader getDataReader(ArrayList entries, PhotometricInterpreter photometricInterpreter, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression) throws IOException, ImageReadException {
            return new DataReaderTiled(photometricInterpreter, this.tileWidth, this.tileLength, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression, this);
        }
    }
}

