/*
 * Decompiled with CFR 0.152.
 */
package edu.dtulnu.stat.brpts.rect;

import java.util.Iterator;
import java.util.Vector;

public class SolutionString
implements Iterator<Integer>,
Comparable<SolutionString> {
    private Vector<Integer> breakPointsIndex;
    private int stringLength;
    private int startNoOfBPs;
    private int minDistBtwBPs;
    private int currentIterIdx;
    private double fitness;
    private boolean debug = false;

    public SolutionString(int length, int startNoOfBPs, int minDistBtwBPs) {
        this.startNoOfBPs = startNoOfBPs;
        this.stringLength = length;
        this.minDistBtwBPs = minDistBtwBPs;
        this.breakPointsIndex = new Vector();
        this.currentIterIdx = 0;
        this.fitness = 1.0;
        this.initString();
    }

    public SolutionString(int length, int minDistBtwBPs) {
        this.startNoOfBPs = 0;
        this.stringLength = length;
        this.minDistBtwBPs = minDistBtwBPs;
        this.breakPointsIndex = new Vector();
        this.currentIterIdx = 0;
        this.fitness = 1.0;
        this.initString();
    }

    public SolutionString(int length, int[] indexes) {
        this.startNoOfBPs = 0;
        this.stringLength = length;
        this.breakPointsIndex = new Vector();
        this.currentIterIdx = 0;
        int i = 0;
        while (i < indexes.length) {
            this.breakPointsIndex.add(indexes[i]);
            ++i;
        }
        this.fitness = 1.0;
    }

    public void initString() {
        if (this.startNoOfBPs * this.minDistBtwBPs > this.stringLength) {
            this.startNoOfBPs = this.stringLength / this.minDistBtwBPs;
            System.out.println("SolutionString: too many break points for minimum distance. Reduced to " + this.startNoOfBPs + ".");
        }
        if (this.startNoOfBPs > 0) {
            this.breakPointsIndex.add(0);
            int skip = this.stringLength / this.startNoOfBPs;
            int idx = 0;
            int count = 0;
            int lastIntervalEnd = 0;
            while (count < this.startNoOfBPs - 1 && idx < this.stringLength - 1) {
                idx = lastIntervalEnd + this.minDistBtwBPs + (int)(Math.random() * (double)(skip - this.minDistBtwBPs));
                if (idx >= this.stringLength) {
                    idx = lastIntervalEnd + 3;
                }
                this.breakPointsIndex.add(idx);
                lastIntervalEnd += skip;
                ++count;
            }
        }
    }

    public int getLength() {
        return this.stringLength;
    }

    public void setFitness(double fitness) {
        this.fitness = fitness;
    }

    public double getFitness() {
        return this.fitness;
    }

    public boolean insertBreakPoint(int afterBPNo) {
        boolean res = false;
        if (this.breakPointsIndex.size() == 0) {
            this.breakPointsIndex.add(0);
            res = true;
        } else if (afterBPNo == this.breakPointsIndex.size() - 1) {
            this.appendBreakPoint();
            res = true;
        } else {
            int idx1 = this.breakPointsIndex.get(afterBPNo);
            int idx2 = this.breakPointsIndex.get(afterBPNo + 1);
            int gap = idx2 - idx1;
            if (gap > 2 * this.minDistBtwBPs) {
                int newIdx = idx1 + gap + (int)(Math.random() * (double)(gap - 2 * this.minDistBtwBPs));
                this.breakPointsIndex.add(afterBPNo + 1, newIdx);
            } else {
                if (this.debug) {
                    System.out.println("WARNING B: SolutionString.insertBreakPoint,  indices not increasing or too close");
                }
                res = false;
            }
        }
        return res;
    }

    public boolean appendBreakPoint() {
        boolean res = false;
        if (this.breakPointsIndex.size() == 0) {
            this.breakPointsIndex.add(0);
            res = true;
        } else {
            int idx1 = this.breakPointsIndex.get(this.breakPointsIndex.size() - 1);
            if (this.stringLength - idx1 > this.minDistBtwBPs) {
                int newIdx = idx1 + (int)(Math.random() * (double)(this.stringLength - idx1 - this.minDistBtwBPs));
                this.breakPointsIndex.add(newIdx);
            } else {
                if (this.debug) {
                    System.out.println("WARNING B: SolutionString.appendBreakPoint, indices not increasing or too close");
                }
                res = false;
            }
        }
        return res;
    }

    public boolean appendBreakPoint(int newBPindex) {
        boolean res = false;
        if (this.breakPointsIndex.size() == 0) {
            this.breakPointsIndex.add(0);
            res = true;
        } else {
            int idx1 = this.breakPointsIndex.get(this.breakPointsIndex.size() - 1);
            if (newBPindex < this.stringLength && newBPindex > idx1 + this.minDistBtwBPs) {
                this.breakPointsIndex.add(newBPindex);
            } else {
                if (this.debug) {
                    System.out.println("WARNING C: SolutionString.appendBreakPoint, indices not increasing or too close");
                }
                res = false;
            }
        }
        return res;
    }

    public String toString() {
        String res = "F = " + this.fitness + "  BPs: ";
        int i = 0;
        while (i < this.breakPointsIndex.size()) {
            res = String.valueOf(res) + "[" + this.breakPointsIndex.get(i) + "] -> ";
            ++i;
        }
        res = String.valueOf(res) + "[" + this.stringLength + "]";
        return res;
    }

    public String toTexString() {
        String res = "Fitness = $" + this.fitness + "$\\\\{} \n  BPs: $";
        int i = 0;
        while (i < this.breakPointsIndex.size()) {
            res = String.valueOf(res) + "[" + this.breakPointsIndex.get(i) + "] \\rightarrow";
            ++i;
        }
        res = String.valueOf(res) + "[" + (this.stringLength - 1) + "]$";
        return res;
    }

    public SolutionString crossOverUniform(SolutionString other) {
        SolutionString result = null;
        if (this.stringLength != other.stringLength) {
            System.out.println("ERROR: SolutionString. crossOver, lengths do not match");
        } else {
            double p2;
            double p1;
            int minDist = Math.max(this.minDistBtwBPs, other.minDistBtwBPs);
            result = new SolutionString(this.stringLength, minDist);
            if (this.fitness + other.fitness == 0.0 || this.fitness <= 0.0 || other.fitness <= 0.0) {
                System.out.println("ERROR Illegal fitnesses " + this.fitness + "  " + other.fitness);
                p1 = 0.5;
                p2 = 0.5;
            } else {
                p1 = this.fitness / (this.fitness + other.fitness);
                p2 = other.fitness / (this.fitness + other.fitness);
            }
            this.resetIterator();
            other.resetIterator();
            boolean thisEmpty = false;
            boolean otherEmpty = false;
            int last = -1;
            int nextthis = this.next();
            int nextother = other.next();
            do {
                if (last == -1) {
                    if (Math.random() < p1) {
                        if (result.appendBreakPoint(0)) {
                            last = nextthis;
                        }
                    } else if (result.appendBreakPoint(0)) {
                        last = nextother;
                    }
                    if (this.hasNext()) {
                        nextthis = this.next();
                    } else {
                        thisEmpty = true;
                    }
                    if (other.hasNext()) {
                        nextother = other.next();
                    } else {
                        otherEmpty = true;
                    }
                }
                if (nextthis == nextother) {
                    if (Math.random() < p1) {
                        if (last + minDist < nextthis) {
                            result.appendBreakPoint(nextthis);
                            last = nextthis;
                        }
                    } else if (last + minDist < nextother) {
                        result.appendBreakPoint(nextother);
                        last = nextother;
                    }
                    if (this.hasNext()) {
                        nextthis = this.next();
                    } else {
                        thisEmpty = true;
                    }
                    if (other.hasNext()) {
                        nextother = other.next();
                        continue;
                    }
                    otherEmpty = true;
                    continue;
                }
                if (nextthis < nextother) {
                    if (Math.random() < p1 && last + minDist < nextthis) {
                        result.appendBreakPoint(nextthis);
                        last = nextthis;
                    }
                    if (this.hasNext()) {
                        nextthis = this.next();
                        continue;
                    }
                    thisEmpty = true;
                    continue;
                }
                if (Math.random() < p2 && last + minDist < nextother) {
                    result.appendBreakPoint(nextother);
                    last = nextother;
                }
                if (other.hasNext()) {
                    nextother = other.next();
                    continue;
                }
                otherEmpty = true;
            } while (this.hasNext() && other.hasNext());
            if (!thisEmpty) {
                while (this.hasNext()) {
                    if (!(Math.random() < p1)) continue;
                    result.appendBreakPoint(nextthis);
                    nextthis = this.next();
                }
                if (Math.random() < p1) {
                    result.appendBreakPoint(nextthis);
                }
            }
            if (!otherEmpty) {
                while (other.hasNext()) {
                    if (!(Math.random() < p2)) continue;
                    result.appendBreakPoint(nextother);
                    nextother = other.next();
                }
                if (Math.random() < p2) {
                    result.appendBreakPoint(nextother);
                }
            }
        }
        return result;
    }

    public SolutionString crossOverOnePoint(SolutionString other) {
        SolutionString result = null;
        if (this.stringLength != other.stringLength) {
            System.out.println("ERROR: SolutionString. crossOver, lengths do not match");
        } else {
            int minDist = Math.max(this.minDistBtwBPs, other.minDistBtwBPs);
            int l = this.stringLength;
            int cutIndex = (int)(Math.random() * (double)l);
            result = new SolutionString(l, minDist);
            this.resetIterator();
            int lastIndexBeforeCut = 0;
            int nextthis = this.next();
            boolean goon = true;
            while (goon && nextthis <= cutIndex) {
                result.appendBreakPoint(nextthis);
                lastIndexBeforeCut = nextthis;
                if (this.hasNext()) {
                    nextthis = this.next();
                    continue;
                }
                goon = false;
            }
            other.resetIterator();
            int nextother = other.next();
            goon = true;
            while (goon && nextother <= cutIndex) {
                if (other.hasNext()) {
                    nextother = other.next();
                    continue;
                }
                goon = false;
            }
            if (goon && nextother > lastIndexBeforeCut + minDist) {
                result.appendBreakPoint(nextother);
            }
            while (other.hasNext()) {
                nextother = other.next();
                if (nextother <= lastIndexBeforeCut + minDist) continue;
                result.appendBreakPoint(nextother);
            }
        }
        return result;
    }

    public SolutionString mutate(double parentProb, double annihilProb) {
        SolutionString result = new SolutionString(this.stringLength, this.minDistBtwBPs);
        int minDist = this.minDistBtwBPs;
        double mutationProb = 2.0 * (double)this.breakPointsIndex.size() / (double)this.stringLength;
        this.resetIterator();
        int next = this.next();
        if (Math.random() < parentProb) {
            result.appendBreakPoint(next);
        } else {
            result.appendBreakPoint(0);
        }
        int mutationIndex = minDist + SolutionString.getDistdistrib(mutationProb);
        while (mutationIndex < this.stringLength - 1) {
            if (Math.random() < parentProb) {
                while (this.hasNext() && next < mutationIndex) {
                    next = this.next();
                }
                if (next == mutationIndex) {
                    result.appendBreakPoint(next);
                }
            } else if (!(Math.random() < annihilProb)) {
                result.appendBreakPoint(mutationIndex);
            }
            mutationIndex += minDist + SolutionString.getDistdistrib(mutationProb);
        }
        return result;
    }

    public SolutionString mutate(double parentProb, double annihilProb, double mutationProb) {
        SolutionString result = new SolutionString(this.stringLength, this.minDistBtwBPs);
        int minDist = this.minDistBtwBPs;
        this.resetIterator();
        int next = this.next();
        if (Math.random() < parentProb) {
            result.appendBreakPoint(next);
        } else {
            result.appendBreakPoint(0);
        }
        int mutationIndex = minDist + SolutionString.getDistdistrib(mutationProb);
        while (mutationIndex < this.stringLength - 1) {
            if (Math.random() < parentProb) {
                while (this.hasNext() && next < mutationIndex) {
                    next = this.next();
                }
                if (next == mutationIndex) {
                    result.appendBreakPoint(next);
                }
            } else if (!(Math.random() < annihilProb)) {
                result.appendBreakPoint(mutationIndex);
            }
            mutationIndex += minDist + SolutionString.getDistdistrib(mutationProb);
        }
        return result;
    }

    private static int getDistdistrib(double mutationProb) {
        return (int)Math.floor(Math.log(Math.random()) / Math.log(1.0 - mutationProb));
    }

    public void resetIterator() {
        this.currentIterIdx = 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentIterIdx < this.breakPointsIndex.size();
    }

    @Override
    public Integer next() {
        return this.breakPointsIndex.get(this.currentIterIdx++);
    }

    @Override
    public void remove() {
    }

    public int[] getBPIndicesAsArray() {
        int[] idx = new int[this.breakPointsIndex.size() + 1];
        int i = 0;
        while (i < idx.length - 1) {
            idx[i] = this.breakPointsIndex.get(i);
            ++i;
        }
        idx[idx.length - 1] = this.stringLength;
        return idx;
    }

    public int getNoOfBPs() {
        return this.breakPointsIndex.size();
    }

    @Override
    public int compareTo(SolutionString other) {
        if (this.fitness < other.fitness) {
            return -1;
        }
        if (this.fitness > other.fitness) {
            return 1;
        }
        return 0;
    }
}

