### R code from vignette source 'Guide.Stex'

###################################################
### code chunk number 1: Guide.Stex:30-31
###################################################
 options(continue="  ")


###################################################
### code chunk number 2: Guide.Stex:158-163
###################################################
  library("TShistQuote")  
  yahoo <- TSconnect("histQuote", dbname="yahoo") 
  x <- TSget("^gspc", quote = "Close", con=yahoo)
  library("tfplot")  
  tfplot(x)


###################################################
### code chunk number 3: Guide.Stex:170-174
###################################################
  library("TSgetSymbol")  
  yahoo <- TSconnect("getSymbol", dbname="yahoo") 
  x <- TSget("^gspc", quote = "Close", con=yahoo)
  tfplot(x)


###################################################
### code chunk number 4: Guide.Stex:186-190
###################################################
ya1 <- TSconnect("getSymbol", dbname="yahoo")
ya2 <- TSconnect("histQuote", dbname="yahoo")
ibmC1 <- TSget("ibm", ya1, quote = "Close", start="2011-01-03")
ibmC2 <- TSget("ibm", ya2, quote = "Close", start="2011-01-03")


###################################################
### code chunk number 5: Guide.Stex:201-202
###################################################
tframe(ibmC1) <- as.Date(tframe(ibmC1))


###################################################
### code chunk number 6: Guide.Stex:206-212
###################################################
tfplot(ibmC2, ibmC1,  
   ylab="IBM Close",
   title="IBM via getSymbol and histQuote",
   lastObs=TRUE, 
   legend=c("via histQuote (black)", "via getSymbol (red)"),
   source="Source: Yahoo")


###################################################
### code chunk number 7: Guide.Stex:216-217
###################################################
max(abs(ibmC2 - ibmC1))


###################################################
### code chunk number 8: Guide.Stex:228-232
###################################################
  TSdescription(x) 
  TSdoc(x) 
  TSlabel(x) 
  TSsource(x) 


###################################################
### code chunk number 9: Guide.Stex:242-245
###################################################
  library("TSgetSymbol")  
  fred <- TSconnect("getSymbol", dbname="FRED") 
  tfplot(TSget("M2", fred))


###################################################
### code chunk number 10: Guide.Stex:251-260
###################################################
  options(TSconnection=fred)
  tfOnePlot(percentChange(TSget("M2"), lag=52), 
    title = "Running commentary, blah, blah, blah", 
    subtitle="Broad Money (M2)",
    ylab= "y/y percent change*",
    source="Source: Federal Reserve Bank of St.Louis (M2)",
    footnoteLeft = "seasonally adjusted data",
    footnoteRight = "* approximated by 52 week growth",
    lastObs = TRUE )


###################################################
### code chunk number 11: Guide.Stex:265-266
###################################################
  options(TSconnection=NULL)


###################################################
### code chunk number 12: Guide.Stex:272-282
###################################################
  x <- TSget(c("CPIAUCNS","M2SL"), fred)
  tfplot(x, 
    title = "Running commentary, blah, blah, blah", 
    subtitle=c("Consumer Price Index for All Urban Consumers: All Items", "Broad Money"),
    ylab= c("Index 1982-84=100", "Billions of dollars"),
    source= c("Data Source: Federal Reserve Bank of St.Louis (CPIAUCNS)",
              "Data Source: Federal Reserve Bank of St.Louis (M2SL)"),
    footnoteLeft  = c("not seasonally adjusted",  "seasonally adjusted"),
    footnoteRight = paste("Extracted:", date()),
    lastObs = TRUE )


###################################################
### code chunk number 13: Guide.Stex:286-287
###################################################
  TSdates(c("CPIAUCNS","M2SL"), fred) 


###################################################
### code chunk number 14: Guide.Stex:294-296
###################################################
  x <- TSget(c("CPIAUCNS","M2SL"), fred, TSrepresentation="zoo")
  class(x) 


###################################################
### code chunk number 15: Guide.Stex:300-301
###################################################
  options(TSrepresentation="zoo")


###################################################
### code chunk number 16: Guide.Stex:305-306
###################################################
  options(TSrepresentation=NULL)


###################################################
### code chunk number 17: Guide.Stex:316-319
###################################################
  yahoo <- TSconnect("getSymbol", dbname="yahoo") 
  x <- TSget("F", con=yahoo)
  plot(x)


###################################################
### code chunk number 18: Guide.Stex:332-333
###################################################
  tfplot(x,series=1:3)


###################################################
### code chunk number 19: Guide.Stex:343-346
###################################################
  tfOnePlot(TSget("F", con=yahoo, quote=c("Open", "Close")),
     title="Ford from Yahoo;  Open (black); Close (red)",
     ylab="Price")


###################################################
### code chunk number 20: Guide.Stex:382-384
###################################################
require("TSjson")
cansim <- TSconnect("json", dbname="cansim")


###################################################
### code chunk number 21: Guide.Stex:388-390
###################################################
x <- TSget("v498086", cansim)
tfplot(x)


###################################################
### code chunk number 22: Guide.Stex:394-398
###################################################
TSdescription("v498086", cansim)
TSdoc("v498086", cansim)
TSlabel("v498086", cansim)
TSsource("v498086", cansim)


###################################################
### code chunk number 23: Guide.Stex:403-408
###################################################
tfplot(ytoypc(x), start=c(1975,1),
   ylab="Year-to-Year Growth Rate",
   title="Canadian GDP", 
   source=paste("Statistics Canada ", seriesNames(x)),
   lastObs=TRUE)


###################################################
### code chunk number 24: Guide.Stex:412-413
###################################################
TSdates(c("v498086", "v498087"), cansim)


###################################################
### code chunk number 25: Guide.Stex:417-420
###################################################
 oldpar <- par(omi=c(0.1,0.1,0.1,0.1),mar=c(3.1,4.1,0.6,0.1))
 tfplot(ytoypc(TSget(c("v498086", "v498087"), cansim)))
 par(oldpar)


###################################################
### code chunk number 26: Guide.Stex:429-443
###################################################
resMorg <- TSget("V122746", cansim, TSdescription=TRUE, TSdoc=TRUE, TSlabel=TRUE)
TSdescription(resMorg)
TSdoc(resMorg)
TSlabel(resMorg)
TSseriesIDs(resMorg)
TSsource(resMorg)
seriesNames(resMorg) <- "Residential Mortgage Credit (SA)"

tfplot(ytoypc(resMorg), annualizedGrowth(resMorg),
   title=seriesNames(resMorg), 
   subtitle="year-to-year (black) and annualize monthly growth (red)",
   ylab="Growth Rate",
   source=paste("Bank of Canada, ", TSsource(x)),
   lastObs=TRUE)


###################################################
### code chunk number 27: Guide.Stex:460-470
###################################################
  library("TSxls")  
  rba <- TSconnect("xls",
          dbname="http://www.rba.gov.au/statistics/tables/xls/d03hist.xls",
          map=list(ids  =list(i=11,     j="B:Q"), 
	           data =list(i=12:627, j="B:Q"), 
	           dates=list(i=12:627, j="A"),
                   names=list(i=4:7,    j="B:Q"), 
		   description = NULL,
		   tsrepresentation = function(data,dates){
		       ts(data,start=c(1959,7), frequency=12)}))


###################################################
### code chunk number 28: Guide.Stex:480-483
###################################################
  x <- TSget("DMACN", rba)
  require("tfplot")
  tfplot(x)


###################################################
### code chunk number 29: Guide.Stex:486-489
###################################################
  x <- TSget(c("DMAM1N", "DMAM3N"), rba)
  tfplot(x)
  TSdescription(x) 


###################################################
### code chunk number 30: Guide.Stex:504-508
###################################################
  tfplot(TSget(c("DMAM1S", "DMAM3S", "DMABMS"), rba),
         TSget(c("DMAM1N", "DMAM3N", "DMABMN"), rba),
    ylab=c("DMAM1", "DMAM3", "DMABM"),
    title="Australian Monetary Aggregates")


###################################################
### code chunk number 31: Guide.Stex:522-526
###################################################
  library("TSzip")  
  pitr <- TSconnect("zip", dbname="http://pitrading.com/free_eod_data")
  z <- TSget("INDU", pitr)
  tfplot(z, series=c(1,4))


###################################################
### code chunk number 32: Guide.Stex:530-536
###################################################
  z <- TSget(c("EURUSD", "GBPUSD"), pitr, quote=c("Open","Close"),
         TSrepresentation=xts)
  tfplot(z,
         title="EURUSD and GBPUSD open and closing values from pitrading", 
         start="1995-01-01",
         par=list(omi=c(0.1,0.3,0.1,0.1),mar=c(2.1,3.1,1.0,0.1)))


###################################################
### code chunk number 33: Guide.Stex:578-584
###################################################
 library("TSMySQL")
 con <- dbConnect("MySQL", dbname="test") 
 require("TSsql")
 removeTSdbTables(con, yesIknowWhatIamDoing=TRUE)
 createTSdbTables(con, index=FALSE)
 dbDisconnect(con)


###################################################
### code chunk number 34: Guide.Stex:599-601
###################################################
 library("TSMySQL")
 con <- TSconnect("MySQL", dbname="test") 


###################################################
### code chunk number 35: Guide.Stex:613-618
###################################################
 z <- ts(rnorm(10), start=c(1990,1), frequency=1)
 seriesNames(z) <- "vec"
 if(TSexists("vec", con)) TSdelete("vec", con) 
 TSput( z, con)
 z <- TSget("vec", con)


###################################################
### code chunk number 36: Guide.Stex:641-646
###################################################
 z <- ts(matrix(rnorm(200),100,2), start=c(1995,1), frequency=12)
  seriesNames(z) <- c("mat2c1", "mat2c2")
 TSreplace(z, con)
 tfplot(z+1, TSget(c("mat2c1","mat2c2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))


###################################################
### code chunk number 37: Guide.Stex:651-657
###################################################
 TSmeta("mat2c1", con)
 TSmeta("vec", con)
 TSdates("vec", con)
 TSdescription("vec", con)
 TSdoc("vec", con)
 TSlabel("vec", con)


###################################################
### code chunk number 38: Guide.Stex:674-688
###################################################
 z <- ts(matrix(rnorm(10),10,1), start=c(1990,1), frequency=1)
 TSreplace(z, serIDs="Series1", con) 
 zz <- TSget("Series1", con)
 TSreplace(z, serIDs="Series1", con, 
     TSdescription="short rnorm series", 
     TSdoc="Series created as an example in the vignette.")
 zz <- TSget("Series1", con, TSdescription=TRUE, TSdoc=TRUE)
 start(zz)
 end(zz)
 TSdescription(zz)
 TSdoc(zz)

 TSdescription("Series1", con)
 TSdoc("Series1", con)


###################################################
### code chunk number 39: Guide.Stex:697-705
###################################################
 require("zoo") 

 z <- zoo(matrix(rnorm(200),100,2), as.Date("1990-01-01") + 0:99)
  seriesNames(z) <- c("zooc1", "zooc2")
 TSreplace(z, con, Table="D")
 tfplot(z+1, TSget(c("zooc1","zooc2"), con),
           lty=c("solid", "dashed"), col=c("black", "red"))
  


###################################################
### code chunk number 40: Guide.Stex:708-711
###################################################
 z <- zoo(matrix(rnorm(200),100,2), as.Date("1990-01-01") + 0:99 * 7)
  seriesNames(z) <- c("zooWc1", "zooWc2")
 TSreplace(z, con, Table="W")


###################################################
### code chunk number 41: Guide.Stex:714-717
###################################################
  dbDisconnect(con)
  detach(package:TSMySQL)
  detach(package:RMySQL)


###################################################
### code chunk number 42: Guide.Stex:738-741
###################################################
  require("TSPostgreSQL")
  host    <- Sys.getenv("POSTGRES_HOST")
  con <-  TSconnect("PostgreSQL", dbname="test", host=host) 


###################################################
### code chunk number 43: Guide.Stex:746-749
###################################################
  require("TShistQuote")
  yahoo <- TSconnect("histQuote", dbname="yahoo") 
  x <- TSget("^gspc", quote = "Close", con=yahoo)


###################################################
### code chunk number 44: Guide.Stex:756-757
###################################################
   TSreplace(x,  serIDs="gspc", Table="B", con=con)


###################################################
### code chunk number 45: Guide.Stex:762-766
###################################################
  TSrefperiod(TSget(serIDs="gspc", con=con)) 
  TSdescription("gspc", con=con) 
  TSdoc("gspc", con=con)
  tfplot(TSget(serIDs="gspc", con=con))


###################################################
### code chunk number 46: Guide.Stex:769-782
###################################################
   x <- TSget("ibm", quote = c("Close", "Vol"), con=yahoo)
   TSreplace(x, serIDs=c("ibm.Cl", "ibm.Vol"),  con=con, Table="B",
              TSdescription.=c("IBM Close","IBM  Volume"),
	      TSdoc.= paste(c(
	         "IBM  Close   retrieved on ",
		 "IBM  Volume retrieved  on "), Sys.Date()))

   z <- TSget(serIDs=c("ibm.Cl", "ibm.Vol"), 
             TSdescription=TRUE, TSdoc=TRUE, con=con)
   TSdescription(z)
   TSdoc(z)
   tfplot(z, xlab = TSdoc(z), title = TSdescription(z))
   tfplot(z, title="IBM", start="2007-01-01")


###################################################
### code chunk number 47: Guide.Stex:819-822
###################################################
   Oanda <- TSconnect("histQuote", dbname="oanda") 
   x <- TSget("EUR/USD", start=Sys.Date() - 495, con=Oanda)
   TSreplace(x, serIDs="EUR/USD", Table="D", con=con)


###################################################
### code chunk number 48: Guide.Stex:827-831
###################################################
   z <- TSget(serIDs="EUR/USD",TSlabel=TRUE, 
                  TSdescription=TRUE,  con=con)
   tfplot(z, title = TSdescription(z), ylab=TSlabel(z),
            start="2007-03-01")


###################################################
### code chunk number 49: Guide.Stex:834-839
###################################################
  dbDisconnect(con)
  dbDisconnect(yahoo)
  dbDisconnect(Oanda)
  detach(package:TSPostgreSQL)
  detach(package:RPostgreSQL)


###################################################
### code chunk number 50: Guide.Stex:951-955
###################################################
library("TScompare")  
library("TShistQuote")  
library("TSMySQL")  
library("TSSQLite")  


###################################################
### code chunk number 51: Guide.Stex:964-974
###################################################
 con <- dbConnect("MySQL", dbname="test") 
 require("TSsql")
 removeTSdbTables(con, yesIknowWhatIamDoing=TRUE)
 createTSdbTables(con, index=FALSE)
 dbDisconnect(con)

 con <- dbConnect("SQLite", dbname="test") 
 removeTSdbTables(con, yesIknowWhatIamDoing=TRUE)
 createTSdbTables(con, index=FALSE)
 dbDisconnect(con)


###################################################
### code chunk number 52: Guide.Stex:978-980
###################################################
  con1 <- TSconnect("MySQL", dbname="test")
  con2 <- TSconnect("SQLite", dbname="test") 


###################################################
### code chunk number 53: Guide.Stex:987-999
###################################################
  yahoo <- TSconnect("histQuote", dbname="yahoo") 
  x <- TSget("^ftse", yahoo)
  TSreplace(x, serIDs="ftse", Table="B", con=con1)
  TSreplace(x, serIDs="ftse", Table="B", con=con2)

  x <- TSget("^gspc", yahoo)
  TSreplace(x,  serIDs="gspc", Table="B", con=con1)
  TSreplace(x,  serIDs="gspc", Table="B", con=con2)

  x <- TSget("ibm", con=yahoo, quote = c("Close", "Vol"))
  TSreplace(x, serIDs=c("ibmClose", "ibmVol"), Table="B", con=con1)
  TSreplace(x, serIDs=c("ibmC",     "ibmV"),   Table="B", con=con2)


###################################################
### code chunk number 54: Guide.Stex:1003-1005
###################################################
  ids <- AllIds(con1)
  ids


###################################################
### code chunk number 55: Guide.Stex:1011-1018
###################################################
  ids <- cbind(ids, ids)

  eq   <- TScompare(ids, con1, con2, na.rm=FALSE)
  summary(eq)

  eqrm <- TScompare(ids, con1, con2, na.rm=TRUE)
  summary(eqrm)


###################################################
### code chunk number 56: Guide.Stex:1023-1032
###################################################
  ids <- matrix(c("ftse","gspc","ibmClose", "ibmVol",
                  "ftse","gspc","ibmC", "ibmV"),4,2)

  ids
  eq   <- TScompare(ids, con1, con2, na.rm=FALSE)
  summary(eq)

  eqrm <- TScompare(ids, con1, con2, na.rm=TRUE)
  summary(eqrm)


###################################################
### code chunk number 57: Guide.Stex:1037-1044
###################################################
  dbDisconnect(con1)
  dbDisconnect(con2)
  dbDisconnect(yahoo)
  detach(package:TSMySQL)
  detach(package:RMySQL)
  detach(package:TSSQLite)
  detach(package:RSQLite)


###################################################
### code chunk number 58: Guide.Stex:1069-1073 (eval = FALSE)
###################################################
## require("TSMySQL") 
## require("tfplot") 
## ets <- TSconnect("MySQL",dbname="etsv") 
## v  <- TSvintages(ets)


###################################################
### code chunk number 59: Guide.Stex:1080-1081 (eval = FALSE)
###################################################
## ve <- TSexists("V122707", vintage=v, con=ets)


###################################################
### code chunk number 60: Guide.Stex:1085-1086 (eval = FALSE)
###################################################
## ve[224:length(ve)] <- FALSE 


###################################################
### code chunk number 61: Guide.Stex:1090-1096 (eval = FALSE)
###################################################
## CC <- TSget(serIDs="V122707", con=ets, vintage=v[ve])
## 
## tfOnePlot(ytoypc(CC), start=c(2000,1), 
##    ylab="Consumer Credit (V122707) y/y Growth",
##    title=paste("Vintages", v[ve][1], "to",  v[ve][189]),
##    lastObs=TRUE, source="Source: Bank of Canada")


###################################################
### code chunk number 62: Guide.Stex:1104-1112 (eval = FALSE)
###################################################
##   dbs <- paste("ets /path/to/etsmfacansim_", c(
##              "20110513.db", "20060526.db", "20110520.db"), sep="")
##   names(dbs) <- c("2011-05-13", "2006-05-26", "2011-05-20")
## 	     
##   conetsV <-TSconnect("fame", dbname=dbs, "read", current="2011-05-13")
## 
##   z <- TSget("V122646", con=conetsV, vintage=c("2011-05-13", "2006-05-26"))
##   dbDisconnect(conetsV)


###################################################
### code chunk number 63: Guide.Stex:1125-1128 (eval = FALSE)
###################################################
## require("googleVis") 
## tfVisPlot(ytoypc(CC, names=seriesNames(CC)), start=c(2006,1),
##     options=list(title="Vintages of Consumer Credit (V122707) y/y Growth"))


###################################################
### code chunk number 64: Guide.Stex:1136-1139 (eval = FALSE)
###################################################
##   dbDisconnect(ets)
##   detach(package:TSMySQL)
##   detach(package:RMySQL)


###################################################
### code chunk number 65: Guide.Stex:1159-1163
###################################################
 require("TSjson")
 cansim <- TSconnect("json", dbname="cansim")
 z <- TSget(c("V36415","V122707","V122746"),  con=cansim)
 seriesNames(z) <- c("Total", "Consumer", "ResMort")


###################################################
### code chunk number 66: Guide.Stex:1169-1172
###################################################
 library("tframePlus")
 library("tfplot")
 tfplot(z, title="Canadian Household Debt")


###################################################
### code chunk number 67: Guide.Stex:1178-1179
###################################################
 z <- trimNA(z, endNAs=FALSE)


###################################################
### code chunk number 68: Guide.Stex:1188-1189
###################################################
 z <- tfwindow(z, start=c(1995,1))


###################################################
### code chunk number 69: Guide.Stex:1195-1199
###################################################
 library("WriteXLS")
 tofile <- tempfile(fileext = ".xls")
 TSwriteXLS(z, FileName=tofile)
 unlink(tofile) 


###################################################
### code chunk number 70: Guide.Stex:1208-1209 (eval = FALSE)
###################################################
## ?TSwriteXLS


###################################################
### code chunk number 71: Guide.Stex:1220-1223
###################################################
 tofile <- tempfile(fileext = ".csv")
 TSwriteCSV(z, FileName=tofile)
 unlink(tofile) 


###################################################
### code chunk number 72: Guide.Stex:1265-1266
###################################################
   user <- Sys.getenv("MYSQL_USER")


###################################################
### code chunk number 73: Guide.Stex:1282-1288
###################################################
 library("TSMySQL")
 con <-  dbConnect("MySQL", dbname="test") 
 require("TSsql")
 removeTSdbTables(con, yesIknowWhatIamDoing=TRUE)
 createTSdbTables(con, index=FALSE)
 dbDisconnect(con)


###################################################
### code chunk number 74: Guide.Stex:1292-1293
###################################################
  con  <-  TSconnect("MySQL", dbname="test")


###################################################
### code chunk number 75: Guide.Stex:1298-1299 (eval = FALSE)
###################################################
## con <-  TSconnect("MySQL", dbname="test", username=user, password=passwd, host=host)


###################################################
### code chunk number 76: Guide.Stex:1306-1308
###################################################
  detach(package:TSMySQL)
  detach(package:RMySQL)


###################################################
### code chunk number 77: Guide.Stex:1329-1330
###################################################
   host    <- Sys.getenv("POSTGRES_HOST")


###################################################
### code chunk number 78: Guide.Stex:1336-1342
###################################################
 library("TSPostgreSQL")
 con  <- dbConnect("PostgreSQL", dbname="test", host=host)
 require("TSsql")
 removeTSdbTables(con, yesIknowWhatIamDoing=TRUE)
 createTSdbTables(con, index=FALSE)
 dbDisconnect(con)


###################################################
### code chunk number 79: Guide.Stex:1346-1347
###################################################
  con  <-  TSconnect("PostgreSQL", dbname="test", host=host)


###################################################
### code chunk number 80: Guide.Stex:1352-1353 (eval = FALSE)
###################################################
##   con <-  TSconnect("PostgreSQL", dbname="test", user=user, password=passwd, host=host)


###################################################
### code chunk number 81: Guide.Stex:1361-1363
###################################################
  detach(package:TSPostgreSQL)
  detach(package:RPostgreSQL)


###################################################
### code chunk number 82: Guide.Stex:1375-1381
###################################################
 library("TSSQLite")
 con <- dbConnect("SQLite", dbname="test") 
 require("TSsql")
 removeTSdbTables(con, yesIknowWhatIamDoing=TRUE)
 createTSdbTables(con, index=FALSE)
 dbDisconnect(con)


###################################################
### code chunk number 83: Guide.Stex:1385-1386
###################################################
  con  <-  TSconnect("SQLite", dbname="test")


###################################################
### code chunk number 84: Guide.Stex:1391-1393
###################################################
  detach(package:TSSQLite)
  detach(package:RSQLite)


###################################################
### code chunk number 85: Guide.Stex:1416-1423
###################################################
 library("TSodbc")
 con <-  odbcConnect(dsn="test") 
 if(con == -1) stop("error establishing ODBC connection.") 
 require("TSsql")
 removeTSdbTables(con, yesIknowWhatIamDoing=TRUE)
 createTSdbTables(con, index=FALSE)
 odbcClose(channel=con)


###################################################
### code chunk number 86: Guide.Stex:1427-1428
###################################################
  con  <-  TSconnect("ODBC", dbname="test")


###################################################
### code chunk number 87: Guide.Stex:1433-1434 (eval = FALSE)
###################################################
## con  <-  TSconnect("ODBC", dbname="test", uid=user, pwd=passwd)


###################################################
### code chunk number 88: Guide.Stex:1443-1445
###################################################
  detach(package:TSodbc)
  detach(package:RODBC)


###################################################
### code chunk number 89: Guide.Stex:1527-1533 (eval = FALSE)
###################################################
##  library("TSOracle")
##  con  <- dbConnect("Oracle", dbname="test") 
##  require("TSsql")
##  removeTSdbTables(con, yesIknowWhatIamDoing=TRUE)
##  createTSdbTables(con, index=FALSE)
##  dbDisconnect(con)


###################################################
### code chunk number 90: Guide.Stex:1538-1539 (eval = FALSE)
###################################################
##   con  <-  TSconnect("Oracle", dbname="test")


###################################################
### code chunk number 91: Guide.Stex:1544-1546 (eval = FALSE)
###################################################
##   detach(package:TSOracle)
##   detach(package:ROracle)


###################################################
### code chunk number 92: Guide.Stex:1556-1558 (eval = FALSE)
###################################################
##  library("TSjson")
##  con  <-  TSconnect("TSjson", dbname="proxy-cansim")


###################################################
### code chunk number 93: Guide.Stex:1578-1580 (eval = FALSE)
###################################################
##   detach(package:TSjson)
##   detach(package:RJSONIO)


###################################################
### code chunk number 94: Guide.Stex:1599-1600 (eval = FALSE)
###################################################
##   con <- TSconnect("fame", dbname="testFame.db") 


###################################################
### code chunk number 95: Guide.Stex:1604-1605 (eval = FALSE)
###################################################
##   con <- TSconnect("fame", dbname="ets /path/to/etsmfacansim.db", "read") 


###################################################
### code chunk number 96: Guide.Stex:1613-1615 (eval = FALSE)
###################################################
##   detach(package:TSfame)
##   detach(package:fame)


###################################################
### code chunk number 97: Guide.Stex:1671-1684
###################################################
 library("TSMySQL")
 con <- dbConnect("MySQL", dbname="test")
 dbListTables(con)
 dbGetQuery(con, "show tables;")
 dbGetQuery(con, "describe A;")
 dbGetQuery(con, "describe B;")
 dbGetQuery(con, "describe D;")
 dbGetQuery(con, "describe M;")
 dbGetQuery(con, "describe Meta;")
 dbGetQuery(con, "describe U;")
 dbGetQuery(con, "describe Q;")
 dbGetQuery(con, "describe S;")
 dbGetQuery(con, "describe W;")


###################################################
### code chunk number 98: Guide.Stex:1693-1707
###################################################
  dbGetQuery(con, paste(
       "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.Columns ",
       " WHERE TABLE_SCHEMA='test' AND table_name='A' ;")) 

  dbGetQuery(con, paste(
       "SELECT COLUMN_NAME, COLUMN_DEFAULT, COLLATION_NAME, DATA_TYPE,",
       "CHARACTER_SET_NAME, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION",
 "FROM INFORMATION_SCHEMA.Columns WHERE TABLE_SCHEMA='test' AND table_name='A' ;"))

  dbGetQuery(con, paste(
   "SELECT COLUMN_NAME, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION",
 "FROM INFORMATION_SCHEMA.Columns WHERE TABLE_SCHEMA='test' AND table_name='M';"))

  dbDisconnect(con)


###################################################
### code chunk number 99: Guide.Stex:1727-1731
###################################################
 library("TSMySQL")
 con <- TSconnect("MySQL", dbname="test") 
 dbGetQuery(con, "SELECT count(*) FROM Meta ;") 
 dbGetQuery(con, "SELECT max(year) FROM A ;") 


###################################################
### code chunk number 100: Guide.Stex:1735-1736
###################################################
dbDisconnect(con)


