/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph.annotations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Vector;
import javax.json.stream.JsonGenerator;
import javax.swing.JFrame;
import org.af.gMCP.gui.graph.annotations.Annotation;
import org.af.gMCP.gui.graph.annotations.AnnotationPanel;
import org.af.gMCP.gui.graph.annotations.Rectangle;
import org.af.gMCP.gui.graph.annotations.TestPanel;
import org.af.gMCP.gui.graph.annotations.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Legend
extends Annotation {
    List<String> lines = new Vector<String>();
    List<Color> colors = new Vector<Color>();
    boolean header = true;
    Font f;
    List<Text> av = new Vector<Text>();
    Rectangle box = null;

    public Legend(int x, int y, List<String> lines, List<Color> colors, AnnotationPanel nl) {
        this(x, y, lines, colors, nl, new Font("Arial", 0, 14));
    }

    public Legend(int x, int y, List<String> lines, List<Color> colors, AnnotationPanel nl, Font font) {
        this.x = x;
        this.y = y;
        this.lines = new Vector<String>(lines);
        this.colors = new Vector<Color>(colors);
        this.nl = nl;
        if (lines.size() != colors.size()) {
            throw new RuntimeException("Number of lines (" + lines.size() + ") and colors " + colors.size() + " does not match.");
        }
        for (int i = 0; i < lines.size(); ++i) {
            this.f = i == 0 && this.header ? font.deriveFont(1) : font;
            this.av.add(new Text(x + 10, y + (i + 1) * 20, lines.get(i), colors.get(i), this.f, nl));
        }
    }

    public void add(int index, String line, Color color) {
        this.lines.add(index, line);
        this.colors.add(index, color);
        this.av.add(index, new Text(this.x + 10, this.y + (index + 1) * 20, line, color, this.f, this.nl));
    }

    public void rm(int index, boolean shiftColors) {
        int i;
        System.out.println("Removing index " + index);
        this.lines.remove(index);
        if (!shiftColors) {
            this.colors.remove(index);
        } else {
            this.colors.remove(this.colors.size() - 1);
        }
        this.av.remove(index);
        for (i = index; i < this.av.size(); ++i) {
            Annotation a = this.av.get(i);
            a.setY(a.getY() - 20);
        }
        if (this.box != null) {
            this.box.height -= 20;
        }
        for (i = 0; i < this.lines.size(); ++i) {
            this.av.get(i).setColor(this.colors.get(i));
        }
    }

    @Override
    public Dimension paintObject(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        int width = 0;
        Dimension d = null;
        if (this.box != null) {
            this.box.paintObject(g);
        }
        for (Annotation annotation : this.av) {
            d = annotation.paintObject(g);
            width = Math.max(d.width, width);
        }
        if (this.box == null) {
            this.box = new Rectangle(this.x, this.y, width + 20, this.lines.size() * 20 + 10, this.nl);
            d = this.box.paintObject(g);
            for (Annotation annotation : this.av) {
                annotation.paintObject(g);
            }
        }
        return d;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setVisible(true);
        f.setSize(800, 600);
        TestPanel tp = new TestPanel();
        f.setContentPane(tp);
        System.out.println(tp.l.saveToJSON());
    }

    @Override
    public void writeObject(JsonGenerator gen) {
        gen.write("lastName", "Java");
    }

    @Override
    public String getLaTeX() {
        return null;
    }

    @Override
    public Annotation readJSON(String json) {
        return null;
    }

    @Override
    public boolean inYou(int x, int y) {
        if (this.box == null) {
            return false;
        }
        return this.box.inYou(x, y);
    }

    @Override
    public void setX(int x) {
        for (Annotation annotation : this.av) {
            annotation.setX(annotation.x + (x - this.x));
        }
        if (this.box != null) {
            this.box.setX(this.box.x + (x - this.x));
        }
        super.setX(x);
    }

    @Override
    public void setY(int y) {
        for (Annotation annotation : this.av) {
            annotation.setY(annotation.y + (y - this.y));
        }
        if (this.box != null) {
            this.box.setY(this.box.y + (y - this.y));
        }
        super.setY(y);
    }

    public void setText(int i, String text) {
        this.av.get(i).setText(text);
    }
}

