/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.gMCP.gui.graph.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedPanel
extends JPanel
implements ActionListener {
    List<JButton> buttons = new Vector<JButton>();
    List<JButton> buttons2 = new Vector<JButton>();
    JTextField jtUserDefined = new JTextField();
    JButton addAnother = new JButton("Add another power function");
    JButton clearList = new JButton("Clear");
    DefaultListModel listModel;
    JList listUserDefined;
    JTextArea jta = new JTextArea();
    JButton loadUDPF = new JButton("Load");
    JButton saveUDPF = new JButton("Save");

    public UserDefinedPanel(List<Node> nodes) {
        JButton b = new JButton("(");
        b.setActionCommand("(");
        this.buttons.add(b);
        b = new JButton(")");
        b.setActionCommand(")");
        this.buttons.add(b);
        b = new JButton("AND");
        b.setActionCommand("&&");
        this.buttons.add(b);
        b = new JButton("OR");
        b.setActionCommand("||");
        this.buttons.add(b);
        b = new JButton("NOT");
        b.setActionCommand("!");
        this.buttons.add(b);
        for (int i = 0; i < nodes.size(); ++i) {
            b = new JButton(nodes.get(i).getName());
            b.setActionCommand("x[" + (i + 1) + "]");
            this.buttons2.add(b);
        }
        JPanel hypPanel = new JPanel();
        for (JButton button : this.buttons2) {
            button.addActionListener(this);
            hypPanel.add(button);
        }
        JPanel opPanel = new JPanel();
        for (JButton button : this.buttons) {
            button.addActionListener(this);
            opPanel.add(button);
        }
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        this.jta.setText("In the text field above you can enter an user defined power function.\nUse the R syntax and \"x[i]\" to specify the proposition that hypothesis i\ncould be rejected. Alternatively use the buttons below.\nExample:  (x[1] && x[2]) || x[4]\nThis calculates the probability that the first and second\nor (not exclusive) the fourth null hypothesis can be rejected.\nNote that you can use all R commands, for example also\nany(x) to see whether any hypotheses was rejected or\nall(x[1:4]) to see whether all of the first four hypotheses were rejected.\nHit return to add another power function.");
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        this.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtUserDefined.addActionListener(this);
        this.add((Component)this.jtUserDefined, cc.xy(2, row));
        this.addAnother.addActionListener(this);
        this.add((Component)this.addAnother, cc.xy(4, row));
        this.listModel = new DefaultListModel();
        this.listUserDefined = new JList(this.listModel);
        this.add((Component)new JScrollPane(this.jta), cc.xywh(2, row += 2, 1, 3));
        this.add((Component)new JScrollPane(this.listUserDefined), cc.xy(4, row));
        this.clearList.addActionListener(this);
        this.add((Component)this.clearList, cc.xy(4, row += 2));
        this.add((Component)new JScrollPane(hypPanel), cc.xyw(2, row += 2, 3));
        this.add((Component)new JScrollPane(opPanel), cc.xyw(2, row += 2, 3));
    }

    String getUserDefined() {
        if (this.listModel.getSize() == 0) {
            return "";
        }
        String s = ", f=list(";
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            s = s + "userDefined" + i + "=function(x) {" + this.listModel.get(i) + "}";
            if (i == this.listModel.getSize() - 1) continue;
            s = s + ",";
        }
        return s + ")";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.buttons.contains(e.getSource()) || this.buttons2.contains(e.getSource())) {
            this.jtUserDefined.setText(this.jtUserDefined.getText() + " " + ((JButton)e.getSource()).getActionCommand());
            return;
        }
        if (e.getSource() == this.clearList) {
            this.listModel.removeAllElements();
            return;
        }
        if (this.jtUserDefined.getText().length() > 0) {
            this.listModel.insertElementAt(this.jtUserDefined.getText(), 0);
            this.jtUserDefined.setText("");
        }
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("powerfunctions");
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            Element ef = document.createElement("userdefined");
            ef.setAttribute("expression", "" + this.listModel.get(i));
            e.appendChild(ef);
        }
        return e;
    }

    public void loadConfig(Element e) {
        NodeList nlist = e.getChildNodes();
        int i = nlist.getLength() - 1;
        while (this.listModel.getSize() < nlist.getLength()) {
            this.listModel.insertElementAt(((Element)nlist.item(i)).getAttribute("expression"), 0);
            --i;
        }
    }
}

